/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

public class FunctionSubjectCanonicalization
extends AbstractSubjectCanonicalizer {
    @NonnullAfterInit
    private Function<SubjectCanonicalizationContext, String> delegatedFunction;

    public void setFunction(@Nonnull Function<SubjectCanonicalizationContext, String> f) {
        this.checkSetterPreconditions();
        this.delegatedFunction = (Function)Constraint.isNotNull(f, (String)"Delegated function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.delegatedFunction == null) {
            throw new ComponentInitializationException("Delegated function cannot be null");
        }
    }

    @Nullable
    public String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        String s;
        String result = this.delegatedFunction.apply(c14nContext);
        if ("proceed".equals(result) && (s = c14nContext.getPrincipalName()) != null) {
            c14nContext.setPrincipalName(this.applyTransforms(s));
        }
        return result;
    }
}

