/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernameContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ExtractRemoteUser
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractRemoteUser.class);
    private boolean checkRemoteUser = true;
    @Nonnull
    private Collection<String> checkAttributes = CollectionSupport.emptyList();
    @Nonnull
    private Collection<String> checkHeaders = CollectionSupport.emptyList();

    public void setCheckRemoteUser(boolean flag) {
        this.checkSetterPreconditions();
        this.checkRemoteUser = flag;
    }

    public void setCheckAttributes(@Nullable Collection<String> attributes) {
        this.checkSetterPreconditions();
        this.checkAttributes = StringSupport.normalizeStringCollection(attributes);
    }

    public void setCheckHeaders(@Nullable Collection<String> headers) {
        this.checkSetterPreconditions();
        this.checkHeaders = StringSupport.normalizeStringCollection(headers);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.checkRemoteUser && this.checkAttributes.isEmpty() && this.checkHeaders.isEmpty()) {
            this.log.debug("{} Configuration contains no headers or attributes to check", (Object)this.getLogPrefix());
            throw new ComponentInitializationException("ExtractRemoteUser action configuration is invalid");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String username;
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        if (this.checkRemoteUser && (username = request.getRemoteUser()) != null && !username.isEmpty()) {
            this.log.debug("{} User identity extracted from REMOTE_USER: {}", (Object)this.getLogPrefix(), (Object)username);
            ((UsernameContext)authenticationContext.ensureSubcontext(UsernameContext.class)).setUsername(this.applyTransforms(profileRequestContext, username));
            return;
        }
        for (String s : this.checkAttributes) {
            Object attr = request.getAttribute(s);
            if (attr == null || attr.toString().isEmpty()) continue;
            this.log.debug("{} User identity extracted from attribute {}: {}", new Object[]{this.getLogPrefix(), s, attr});
            ((UsernameContext)authenticationContext.ensureSubcontext(UsernameContext.class)).setUsername(this.applyTransforms(profileRequestContext, attr.toString()));
            return;
        }
        for (String s : this.checkHeaders) {
            username = request.getHeader(s);
            if (username == null || username.isEmpty()) continue;
            this.log.debug("{} User identity extracted from header {}: {}", new Object[]{this.getLogPrefix(), s, username});
            ((UsernameContext)authenticationContext.ensureSubcontext(UsernameContext.class)).setUsername(this.applyTransforms(profileRequestContext, username));
            return;
        }
        this.log.debug("{} No user identity found in request", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
    }
}

