/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin;

import com.google.common.base.MoreObjects;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.admin.AdministrativeFlowDescriptor;
import net.shibboleth.idp.authn.principal.PrincipalServiceManager;
import net.shibboleth.idp.profile.config.AbstractInterceptorAwareProfileConfiguration;
import net.shibboleth.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LangBearingString;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.InformationURL;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.security.config.SecurityConfiguration;

public class BasicAdministrativeFlowDescriptor
extends AbstractInterceptorAwareProfileConfiguration
implements AdministrativeFlowDescriptor,
OverriddenIssuerProfileConfiguration {
    @Nullable
    private String loggingId;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> supportsNonBrowserPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> authenticatedPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private final UIInfo uiInfo;
    @Nonnull
    private Function<ProfileRequestContext, String> policyNameLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> requestedIdPAttributeNamesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> attributeRecipientGroupIDLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<Principal>> defaultAuthenticationMethodsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> stringBasedPrincipalsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;
    @Nonnull
    private final XMLObjectBuilderFactory builderFactory;
    @Nullable
    private PrincipalServiceManager principalServiceManager;

    public BasicAdministrativeFlowDescriptor(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        super(id);
        this.resolveAttributesPredicate = PredicateSupport.alwaysFalse();
        this.requestedIdPAttributeNamesLookupStrategy = FunctionSupport.constant(null);
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant(null);
        this.builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.uiInfo = (UIInfo)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(UIInfo.DEFAULT_ELEMENT_NAME)).buildObject();
        this.defaultAuthenticationMethodsLookupStrategy = FunctionSupport.constant(null);
        this.stringBasedPrincipalsLookupStrategy = FunctionSupport.constant(null);
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
    }

    public void setPrincipalServiceManager(@Nullable PrincipalServiceManager manager) {
        this.principalServiceManager = manager;
    }

    @Override
    @Nullable
    public String getLoggingId() {
        return this.loggingId;
    }

    public void setLoggingId(@Nullable String id) {
        this.loggingId = StringSupport.trimOrNull((String)id);
    }

    @Nullable
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable String id) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)id));
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Override
    public boolean isNonBrowserSupported(@Nullable ProfileRequestContext profileRequestContext) {
        return this.supportsNonBrowserPredicate.test(profileRequestContext);
    }

    public void setNonBrowserSupported(boolean flag) {
        this.supportsNonBrowserPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setNonBrowserSupportedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.supportsNonBrowserPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Non-browser support condition cannot be null");
    }

    @Override
    public boolean isAuthenticated(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authenticatedPredicate.test(profileRequestContext);
    }

    public void setAuthenticated(boolean flag) {
        this.authenticatedPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAuthenticatedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.authenticatedPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Authentication condition cannot be null");
    }

    @Override
    @Nonnull
    public UIInfo getUIInfo() {
        return this.uiInfo;
    }

    public void setDisplayNames(@Nonnull Collection<LangBearingString> displayNames) {
        this.uiInfo.getDisplayNames().clear();
        for (LangBearingString s : displayNames) {
            DisplayName displayName = (DisplayName)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(DisplayName.DEFAULT_ELEMENT_NAME)).buildObject();
            displayName.setValue(s.getValue());
            displayName.setXMLLang(s.getLang());
            this.uiInfo.getDisplayNames().add(displayName);
        }
    }

    public void setDescriptions(@Nonnull Collection<LangBearingString> descriptions) {
        this.uiInfo.getDescriptions().clear();
        for (LangBearingString s : descriptions) {
            Description desc = (Description)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(Description.DEFAULT_ELEMENT_NAME)).buildObject();
            desc.setValue(s.getValue());
            desc.setXMLLang(s.getLang());
            this.uiInfo.getDescriptions().add(desc);
        }
    }

    public void setLogos(@Nonnull Collection<Logo> logos) {
        this.uiInfo.getLogos().clear();
        for (Logo src : logos) {
            org.opensaml.saml.ext.saml2mdui.Logo logo = (org.opensaml.saml.ext.saml2mdui.Logo)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(org.opensaml.saml.ext.saml2mdui.Logo.DEFAULT_ELEMENT_NAME)).buildObject();
            logo.setURI(src.getValue());
            logo.setXMLLang(src.getLang());
            logo.setHeight(Integer.valueOf(src.getHeight()));
            logo.setWidth(Integer.valueOf(src.getWidth()));
            this.uiInfo.getLogos().add(logo);
        }
    }

    public void setInformationURLs(@Nonnull Collection<LangBearingString> urls) {
        this.uiInfo.getInformationURLs().clear();
        for (LangBearingString s : urls) {
            InformationURL url = (InformationURL)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(InformationURL.DEFAULT_ELEMENT_NAME)).buildObject();
            url.setURI(s.getValue());
            url.setXMLLang(s.getLang());
            this.uiInfo.getInformationURLs().add(url);
        }
    }

    public void setPrivacyStatementURLs(@Nonnull Collection<LangBearingString> urls) {
        this.uiInfo.getPrivacyStatementURLs().clear();
        for (LangBearingString s : urls) {
            PrivacyStatementURL url = (PrivacyStatementURL)((SAMLObjectBuilder)this.builderFactory.ensureBuilder(PrivacyStatementURL.DEFAULT_ELEMENT_NAME)).buildObject();
            url.setURI(s.getValue());
            url.setXMLLang(s.getLang());
            this.uiInfo.getPrivacyStatementURLs().add(url);
        }
    }

    @Override
    @Nullable
    public String getPolicyName(@Nullable ProfileRequestContext profileRequestContext) {
        return this.policyNameLookupStrategy.apply(profileRequestContext);
    }

    public void setPolicyName(@Nullable String name) {
        this.policyNameLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)name));
    }

    public void setPolicyNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.policyNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Policy lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getRequestedIdPAttributeNames(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> names = this.requestedIdPAttributeNamesLookupStrategy.apply(profileRequestContext);
        if (names != null) {
            return CollectionSupport.copyToSet(names);
        }
        return CollectionSupport.emptySet();
    }

    public void setRequestedIdPAttributeNames(@Nullable Collection<String> names) {
        this.requestedIdPAttributeNamesLookupStrategy = names == null || names.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names)));
    }

    public void setRequestedIdPAttributeNamesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.requestedIdPAttributeNamesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requested IdPAttribute names lookup strategy cannot be null");
    }

    @Nullable
    public String getAttributeRecipientGroupID(@Nullable ProfileRequestContext profileRequestContext) {
        return this.attributeRecipientGroupIDLookupStrategy.apply(profileRequestContext);
    }

    public void setAttributeRecipientGroupID(@Nullable String groupID) {
        this.attributeRecipientGroupIDLookupStrategy = FunctionSupport.constant((Object)groupID);
    }

    public void setAttributeRecipientGroupIDLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.attributeRecipientGroupIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Group ID lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        return CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getOutboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        return CollectionSupport.emptyList();
    }

    @Nullable
    public SecurityConfiguration getSecurityConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return null;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> stringBasedPrincipals;
        PrincipalServiceManager psm = this.principalServiceManager;
        if (psm != null && (stringBasedPrincipals = this.stringBasedPrincipalsLookupStrategy.apply(profileRequestContext)) != null && !stringBasedPrincipals.isEmpty()) {
            ArrayList principals = new ArrayList(stringBasedPrincipals.size());
            stringBasedPrincipals.forEach(v -> {
                Principal p = psm.principalFromString(v);
                if (p != null) {
                    principals.add(p);
                }
            });
            return CollectionSupport.copyToList(principals);
        }
        Collection<Principal> methods = this.defaultAuthenticationMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToList(methods);
        }
        return CollectionSupport.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable Collection<Principal> methods) {
        this.defaultAuthenticationMethodsLookupStrategy = methods != null ? FunctionSupport.constant(List.copyOf(methods)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.defaultAuthenticationMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setDefaultAuthenticationMethodsByString(@Nullable Collection<String> methods) {
        this.stringBasedPrincipalsLookupStrategy = methods != null ? FunctionSupport.constant(List.copyOf(methods)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsByStringLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.stringBasedPrincipalsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToSet(flows);
        }
        return CollectionSupport.emptySet();
    }

    public void setAuthenticationFlows(@Nullable Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BasicAdministrativeFlowDescriptor) {
            return this.getId().equals(((BasicAdministrativeFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).toString();
    }

    public static class Logo
    extends LangBearingString {
        private final int height;
        private final int width;

        public Logo(@Nullable String url, @Nullable @NotEmpty String lang, @Positive int h, @Positive int w) {
            super(url, lang);
            this.height = Constraint.isGreaterThan((int)0, (int)h, (String)"Height must be greater than zero.");
            this.width = Constraint.isGreaterThan((int)0, (int)w, (String)"Width must be greater than zero.");
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

