/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.spring.factory;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

class FlowRelativeResourceLoader
extends DefaultResourceLoader {
    @Nonnull
    private Resource flowResource;

    public FlowRelativeResourceLoader(@Nonnull Resource resource) {
        this.flowResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Flow resource cannot be null");
        this.getProtocolResolvers().add(new ConditionalResourceResolver());
    }

    public ClassLoader getClassLoader() {
        return this.flowResource.getClass().getClassLoader();
    }

    @Nonnull
    public Resource getResource(@Nonnull String location) {
        try {
            Resource r = super.getResource(location);
            if (r.exists()) {
                return r;
            }
        }
        catch (Exception r) {
            // empty catch block
        }
        if (location.startsWith("classpath:")) {
            String subString = location.substring("classpath:".length());
            assert (subString != null);
            return new ClassPathResource(subString, this.getClassLoader());
        }
        return this.createFlowRelativeResource(location);
    }

    @Nonnull
    private Resource createFlowRelativeResource(@Nonnull String location) {
        try {
            return this.flowResource.createRelative(location);
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Unable to access a flow relative resource at location '" + location + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    @Nonnull
    protected Resource getResourceByPath(@Nonnull String path) {
        try {
            FileSystemResource r = new FileSystemResource(path);
            if (r.exists()) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getResourceByPath(path);
    }
}

