/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class ServiceLogoTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5309357312113020929L;
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(ServiceLogoTag.class);
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_VALUE = "";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_ALT_TXT = "SP Logo";
    private int minWidth;
    private int maxWidth = Integer.MAX_VALUE;
    private int minHeight;
    private int maxHeight = Integer.MAX_VALUE;
    @Nullable
    private String altTxt;

    public void setMaxWidth(Integer value) {
        this.maxWidth = value;
    }

    public void setMinWidth(Integer value) {
        this.minWidth = value;
    }

    public void setMinHeight(Integer value) {
        this.minHeight = value;
    }

    public void setMaxHeight(Integer value) {
        this.maxHeight = value;
    }

    public void setAlt(String value) {
        this.altTxt = value;
    }

    @Nullable
    private String getLogoFromUIInfo() {
        RelyingPartyUIContext ctx = this.getRelyingPartyUIContext();
        if (ctx == null) {
            return null;
        }
        return ctx.getLogo(this.minWidth, this.minHeight, this.maxWidth, this.maxHeight);
    }

    @Nullable
    private String getAltText() {
        String value = this.altTxt;
        if (null != value && 0 != value.length()) {
            return value;
        }
        value = this.getServiceName();
        if (null != value && 0 != value.length()) {
            return value;
        }
        return DEFAULT_ALT_TXT;
    }

    @Nullable
    private String getHyperlink() {
        String url = this.getLogoFromUIInfo();
        if (null == url) {
            return null;
        }
        try {
            URI theUrl = new URI(url);
            String scheme = theUrl.getScheme();
            if (!("http".equals(scheme) || "https".equals(scheme) || "data".equals(scheme))) {
                log.warn("The logo URL '{}' contained an invalid scheme (expected http:, https: or data:)", (Object)url);
                return null;
            }
        }
        catch (URISyntaxException e) {
            log.warn("The logo URL '{}' was not a URL ", (Object)url, (Object)e);
            return null;
        }
        String encodedURL = HTMLEncoder.encodeForHTMLAttribute((String)url);
        String encodedAltTxt = HTMLEncoder.encodeForHTMLAttribute((String)this.getAltText());
        StringBuilder sb = new StringBuilder("<img src=\"");
        sb.append(encodedURL).append('\"');
        sb.append(" alt=\"").append(encodedAltTxt).append('\"');
        this.addClassAndId(sb);
        sb.append("/>");
        return sb.toString();
    }

    public int doEndTag() throws JspException {
        String result = this.getHyperlink();
        try {
            if (null == result) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                boolean written = false;
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                    written = true;
                }
                if (!written) {
                    this.pageContext.getOut().print(DEFAULT_VALUE);
                }
            } else {
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating Logo: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

