/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableServiceGaugeSet;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class AttributeResolverServiceGaugeSet
extends ReloadableServiceGaugeSet<AttributeResolver>
implements MetricSet,
MetricFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceGaugeSet.class);

    public AttributeResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"success"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                try (ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();){
                    Object resolver = component.getComponent();
                    if (resolver instanceof AttributeResolverImpl) {
                        Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            if (connector.getLastSuccess() == null) continue;
                            mapBuilder.put(connector.getId(), connector.getLastSuccess());
                        }
                    } else if (resolver instanceof AttributeResolver) {
                        AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector success  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    } else {
                        AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return Map.copyOf(mapBuilder);
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"failure"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                try (ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();){
                    Object resolver = component.getComponent();
                    if (resolver instanceof AttributeResolverImpl) {
                        Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            if (connector.getLastFail() == null) continue;
                            mapBuilder.put(connector.getId(), connector.getLastFail());
                        }
                    } else if (resolver instanceof AttributeResolver) {
                        AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector failure  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    } else {
                        AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return Map.copyOf(mapBuilder);
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"cache"}), new Gauge<Map<String, CacheStatsPojo>>(){

            public Map<String, CacheStatsPojo> getValue() {
                HashMap<String, CacheStatsPojo> mapBuilder = new HashMap<String, CacheStatsPojo>();
                try (ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();){
                    Object resolver = component.getComponent();
                    if (resolver instanceof AttributeResolverImpl) {
                        Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            AbstractSearchDataConnector search;
                            Cache<String, Map<String, IdPAttribute>> cache;
                            CacheStats stats;
                            if (!(connector instanceof AbstractSearchDataConnector) || (stats = (cache = (search = (AbstractSearchDataConnector)connector).getResultsCache()) == null ? null : cache.stats()) == null) continue;
                            mapBuilder.put(connector.getId(), new CacheStatsPojo(stats));
                        }
                    } else if (resolver instanceof AttributeResolver) {
                        AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector failure  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    } else {
                        AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return Map.copyOf(mapBuilder);
            }
        });
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try (ServiceableComponent component = this.getService().getServiceableComponent();){
            if (component != null) {
                if (component.getComponent() instanceof AttributeResolver) {
                    return;
                }
                this.log.error("{}: Injected service was not for an AttributeResolver ({})", (Object)this.getLogPrefix(), component.getClass());
                throw new ComponentInitializationException("Injected service was not for an AttributeResolver");
            }
        }
        catch (ServiceException e) {
            this.log.debug("{} : Injected service has not initialized sucessfully yet. Skipping type test", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    public static class CacheStatsPojo {
        final long hitCount;
        public final long missCount;
        public final long loadSuccessCount;
        public final long loadExceptionCount;
        public final long evictionCount;

        CacheStatsPojo(CacheStats s) {
            this.hitCount = s.hitCount();
            this.missCount = s.missCount();
            this.loadExceptionCount = s.loadExceptionCount();
            this.loadSuccessCount = s.loadSuccessCount();
            this.evictionCount = s.evictionCount();
        }
    }
}

