/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.util.impl;

import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.messaging.AssertionValidationInput;
import org.opensaml.saml.saml2.assertion.messaging.AssertionValidationNetworkInformationSupplier;
import org.opensaml.saml.saml2.assertion.messaging.BasicNetworkInformationSupplier;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;

public class AssertionValidationProcessor
extends AbstractInitializableComponent {
    private Logger log = LoggerFactory.getLogger(AssertionValidationProcessor.class);
    @NonnullAfterInit
    private Function<AssertionValidationInput, ValidationContext> assertionValidationContextBuilder;
    @NonnullAfterInit
    private Function<Pair<InOutOperationContext, Assertion>, SAML20AssertionValidator> assertionValidatorLookup;

    @NonnullAfterInit
    public Function<AssertionValidationInput, ValidationContext> getAssertionValidationContextBuilder() {
        return this.assertionValidationContextBuilder;
    }

    public void setAssertionValidationContextBuilder(@Nonnull Function<AssertionValidationInput, ValidationContext> builder) {
        this.checkSetterPreconditions();
        this.assertionValidationContextBuilder = (Function)Constraint.isNotNull(builder, (String)"ValidationContext builder cannot be null");
    }

    public void setAssertionValidator(@Nullable SAML20AssertionValidator validator) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = FunctionSupport.constant((Object)validator);
    }

    @NonnullAfterInit
    public Function<Pair<InOutOperationContext, Assertion>, SAML20AssertionValidator> getAssertionValidatorLookup() {
        return this.assertionValidatorLookup;
    }

    public void setAssertionValidatorLookup(@Nonnull Function<Pair<InOutOperationContext, Assertion>, SAML20AssertionValidator> function) {
        this.checkSetterPreconditions();
        this.assertionValidatorLookup = (Function)Constraint.isNotNull(function, (String)"AssertionValidator lookup function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAssertionValidationContextBuilder() == null) {
            throw new ComponentInitializationException("Assertion validation context builder was null");
        }
        if (this.getAssertionValidatorLookup() == null) {
            throw new ComponentInitializationException("Assertion validator lookup function was null");
        }
    }

    public void validateAssertions(@Nonnull Response response, @Nonnull InOutOperationContext opContext) throws ResolutionException {
        this.checkComponentActive();
        ArrayList<Assertion> notValid = new ArrayList<Assertion>();
        for (Assertion assertion : response.getAssertions()) {
            assert (assertion != null);
            SAML20AssertionValidator validator = this.getAssertionValidatorLookup().apply((Pair<InOutOperationContext, Assertion>)new Pair((Object)opContext, (Object)assertion));
            if (validator == null) {
                this.log.warn("No SAML20AssertionValidator was available, terminating");
                throw new ResolutionException("No SAML20AssertionValidator was available");
            }
            try {
                ValidationContext validationContext = this.buildValidationContext(opContext, assertion);
                ValidationResult validationResult = validator.validate(assertion, validationContext);
                if (validationResult != ValidationResult.VALID) {
                    notValid.add(assertion);
                }
                this.processAssertionValidationResult(validationContext, validationResult, assertion, opContext);
            }
            catch (Exception e) {
                this.log.warn("There was a problem determining Assertion validity", (Throwable)e);
                throw new ResolutionException("There was a problem determing SAML Assertion validity", e);
            }
        }
        response.getAssertions().removeAll(notValid);
    }

    @Nonnull
    protected ValidationContext buildValidationContext(@Nonnull InOutOperationContext opContext, @Nonnull Assertion assertion) throws AssertionValidationException {
        BasicNetworkInformationSupplier networkInformation = new BasicNetworkInformationSupplier();
        ValidationContext validationContext = this.getAssertionValidationContextBuilder().apply(new AssertionValidationInput(assertion, opContext, (AssertionValidationNetworkInformationSupplier)networkInformation));
        if (validationContext == null) {
            this.log.warn("ValidationContext produced was null");
            throw new AssertionValidationException("Assertion ValidationContext was null");
        }
        return validationContext;
    }

    protected void processAssertionValidationResult(@Nonnull ValidationContext validationContext, @Nonnull ValidationResult validationResult, @Nonnull Assertion assertion, @Nonnull InOutOperationContext opContext) {
        this.log.debug("Assertion validation result was: {}", (Object)validationResult);
        if (validationResult != ValidationResult.VALID) {
            this.log.info("Assertion validation failure(s): {}", (Object)validationContext.getValidationFailureMessages());
        }
        assertion.getObjectMetadata().put((Object)new ValidationProcessingData(validationContext, validationResult));
    }
}

