/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SubjectResolver;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class DependencyAttributeSubjectResolver
extends AbstractInitializableComponent
implements SubjectResolver {
    @Nonnull
    final Logger log = LoggerFactory.getLogger(DependencyAttributeSubjectResolver.class);
    @Nonnull
    private List<String> attributeIDs = CollectionSupport.emptyList();
    @Nonnull
    private Map<String, String> nameIDFormatMap = CollectionSupport.emptyMap();
    @Nullable
    private String defaultNameIDFormat;

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getAttributeIDs() {
        return this.attributeIDs;
    }

    public void setAttributeIDs(@Nullable List<String> values) {
        this.checkSetterPreconditions();
        this.attributeIDs = values == null ? CollectionSupport.emptyList() : CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(values));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, String> getNameIDFormatMap() {
        return this.nameIDFormatMap;
    }

    public void setNameIDFormatMap(@Nullable Map<String, String> formatMap) {
        this.checkSetterPreconditions();
        this.nameIDFormatMap = formatMap == null ? CollectionSupport.emptyMap() : CollectionSupport.copyToMap(formatMap);
    }

    @Nullable
    public String getDefaultNameIDFormat() {
        return this.defaultNameIDFormat;
    }

    public void setDefaultNameIDFormat(@Nullable String uri) {
        this.checkSetterPreconditions();
        this.defaultNameIDFormat = StringSupport.trimOrNull((String)uri);
    }

    @Override
    @Nullable
    public Subject resolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        this.checkComponentActive();
        for (String attributeID : this.getAttributeIDs()) {
            assert (attributeID != null);
            this.log.trace("Evaluating attribute ID: {}", (Object)attributeID);
            if (!dependencyAttributes.containsKey(attributeID)) continue;
            this.log.trace("Dependency attribute '{}' present, checking values");
            for (IdPAttributeValue value : dependencyAttributes.get(attributeID)) {
                XMLObjectAttributeValue xmlObjectValue;
                String scopedString;
                if (value instanceof StringAttributeValue) {
                    StringAttributeValue stringValue = (StringAttributeValue)value;
                    this.log.debug("In dependency attribute '{}' found string value '{}'", (Object)attributeID, (Object)stringValue.getValue());
                    return this.buildSubject(stringValue.getValue(), attributeID);
                }
                if (value instanceof ScopedStringAttributeValue) {
                    ScopedStringAttributeValue scopedStringValue = (ScopedStringAttributeValue)value;
                    scopedString = scopedStringValue.getValue() + "@" + scopedStringValue.getScope();
                    this.log.debug("In dependency attribute '{}' found scoped string value '{}'", (Object)attributeID, (Object)scopedString);
                    return this.buildSubject(scopedString, attributeID);
                }
                if (!(value instanceof XMLObjectAttributeValue) || !((scopedString = (xmlObjectValue = (XMLObjectAttributeValue)value).getValue()) instanceof NameID)) continue;
                NameID nameIDValue = (NameID)scopedString;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("In dependency attribute '{}' found NameID value '{}'", (Object)attributeID, (Object)SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)nameIDValue)));
                    }
                }
                catch (MarshallingException e) {
                    this.log.debug("Error while marshalling+serializing NameID for logging", (Throwable)e);
                }
                Subject subject = this.buildSubject(nameIDValue);
                if (subject != null) {
                    return subject;
                }
                this.log.warn("Error constructing Subject from NameID value, processing remaining attributes");
            }
        }
        this.log.debug("Could not resolve Subject based on dependency attributes");
        return null;
    }

    @Nonnull
    private Subject buildSubject(@Nonnull String value, @Nonnull String attributeID) {
        NameID nameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue(value);
        nameID.setFormat(this.determinieNameIDFormat(attributeID));
        Subject subject = (Subject)XMLObjectSupport.buildXMLObject((QName)Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameID(nameID);
        return subject;
    }

    @Nullable
    private Subject buildSubject(@Nonnull NameID value) {
        try {
            NameID nameID = (NameID)XMLObjectSupport.cloneXMLObject((XMLObject)value);
            Subject subject = (Subject)XMLObjectSupport.buildXMLObject((QName)Subject.DEFAULT_ELEMENT_NAME);
            subject.setNameID(nameID);
            return subject;
        }
        catch (MarshallingException | UnmarshallingException e) {
            this.log.warn("Fatal error cloning NameID for Subject construction", e);
            return null;
        }
    }

    @Nullable
    private String determinieNameIDFormat(@Nonnull String attributeID) {
        String mappedValue = this.getNameIDFormatMap().get(attributeID);
        if (mappedValue != null) {
            return mappedValue;
        }
        return this.getDefaultNameIDFormat();
    }
}

