/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SelfEntityIDResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.ChainingSelfEntityIDResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.Resolver;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class CriteriaSelfEntityIDResolver
extends AbstractInitializableComponent
implements SelfEntityIDResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ChainingSelfEntityIDResolver.class);
    @NonnullAfterInit
    private Resolver<String, CriteriaSet> selfEntityIDResolver;

    @NonnullAfterInit
    public Resolver<String, CriteriaSet> getSelfEntityIDResolver() {
        return this.selfEntityIDResolver;
    }

    public void setSelfEntityIDResolver(@Nullable Resolver<String, CriteriaSet> resolver) {
        this.checkSetterPreconditions();
        this.selfEntityIDResolver = resolver;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.selfEntityIDResolver == null) {
            throw new ComponentInitializationException("Self entityID resolver cannot be null");
        }
    }

    @Override
    @Nullable
    public String resolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        this.checkComponentActive();
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new RoleDescriptorCriterion((RoleDescriptor)roleDescriptor)});
        try {
            String selfEntityID = (String)this.getSelfEntityIDResolver().resolveSingle((Object)criteria);
            if (selfEntityID == null) {
                throw new ResolutionException("Unable to resolve self entityID from peer RoleDescriptor");
            }
            this.log.debug("Resolved self entityID via criteria: {}", (Object)selfEntityID);
            return selfEntityID;
        }
        catch (ResolverException e) {
            throw new ResolutionException("Fatal error resolving self entityID from peer RoleDescriptor", (Exception)((Object)e));
        }
    }
}

