/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.ChainingSelfEntityIDResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.Resolver;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.criterion.ProfileIDCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.slf4j.Logger;

public class CriteriaDecryptionConfigurationLookup
extends AbstractInitializableComponent
implements Function<ResponseData, List<DecryptionConfiguration>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ChainingSelfEntityIDResolver.class);
    @NonnullAfterInit
    private Resolver<List<DecryptionConfiguration>, CriteriaSet> configurationResolver;
    @NonnullAfterInit
    private String securityConfigurationProfileId;

    @NonnullAfterInit
    public Resolver<List<DecryptionConfiguration>, CriteriaSet> getConfigurationResolver() {
        return this.configurationResolver;
    }

    public void setConfigurationResolver(@Nullable Resolver<List<DecryptionConfiguration>, CriteriaSet> resolver) {
        this.checkSetterPreconditions();
        this.configurationResolver = resolver;
    }

    public void setSecurityConfigurationProfileId(@Nullable String profileId) {
        this.checkSetterPreconditions();
        this.securityConfigurationProfileId = StringSupport.trimOrNull((String)profileId);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.configurationResolver == null) {
            throw new ComponentInitializationException("DecryptionConfiguration resolver cannot be null");
        }
        if (this.securityConfigurationProfileId == null) {
            throw new ComponentInitializationException("Security config profile ID cannot be null");
        }
    }

    @Override
    @Nullable
    public List<DecryptionConfiguration> apply(@Nullable ResponseData responseData) {
        this.checkComponentActive();
        if (responseData == null) {
            return CollectionSupport.emptyList();
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new RoleDescriptorCriterion(responseData.getAttributeAuthorityRoleDescriptor()), new ProfileIDCriterion(this.securityConfigurationProfileId)});
        try {
            List configs = (List)this.getConfigurationResolver().resolveSingle((Object)criteria);
            if (configs == null) {
                this.log.warn("Failed to resolve list of DecryptionConfiguration from criteria");
                return null;
            }
            return configs;
        }
        catch (ResolverException e) {
            this.log.warn("Fatal error resolving DecryptionConfiguration via criteria");
            return null;
        }
    }
}

