/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SubjectResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.slf4j.Logger;

public class ChainingSubjectResolver
extends AbstractInitializableComponent
implements SubjectResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingSubjectResolver.class);
    @NonnullAfterInit
    private List<SubjectResolver> resolvers;

    @NotLive
    @Unmodifiable
    @NonnullAfterInit
    public List<SubjectResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable List<SubjectResolver> chain) {
        this.checkSetterPreconditions();
        this.resolvers = chain == null ? CollectionSupport.emptyList() : (List)((NonnullSupplier)chain.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getResolvers() == null) {
            throw new ComponentInitializationException("List chain member resolvers was null");
        }
    }

    @Override
    @Nullable
    public Subject resolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        this.checkComponentActive();
        for (SubjectResolver resolver : this.getResolvers()) {
            Subject subject = resolver.resolve(resolutionContext, dependencyAttributes, roleDescriptor);
            if (subject == null) continue;
            this.log.debug("Resolved Subject using resolver impl: {}", (Object)resolver.getClass().getName());
            return subject;
        }
        return null;
    }
}

