/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.AttributeAuthorityEntityIDResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.slf4j.Logger;

public class ChainingAuthorityEntityIDResolver
extends AbstractInitializableComponent
implements AttributeAuthorityEntityIDResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingAuthorityEntityIDResolver.class);
    @NonnullAfterInit
    private List<AttributeAuthorityEntityIDResolver> resolvers;

    @NotLive
    @Unmodifiable
    @NonnullAfterInit
    public List<AttributeAuthorityEntityIDResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(@Nullable List<AttributeAuthorityEntityIDResolver> chain) {
        this.checkSetterPreconditions();
        this.resolvers = chain == null ? CollectionSupport.emptyList() : (List)((NonnullSupplier)chain.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getResolvers() == null) {
            throw new ComponentInitializationException("List chain member resolvers was null");
        }
    }

    @Override
    @Nullable
    public String resolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        this.checkComponentActive();
        for (AttributeAuthorityEntityIDResolver resolver : this.getResolvers()) {
            String entityID = resolver.resolve(resolutionContext, dependencyAttributes);
            if (entityID == null) continue;
            this.log.debug("Resolved entityID '{}' using resolver impl: {}", (Object)entityID, (Object)resolver.getClass().getName());
            return entityID;
        }
        return null;
    }
}

