/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearch;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.MappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public abstract class AbstractSearchDataConnector<T1 extends ExecutableSearch, T2 extends MappingStrategy<?>>
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSearchDataConnector.class);
    @NonnullAfterInit
    private ExecutableSearchBuilder<T1> searchBuilder;
    @NonnullAfterInit
    private Validator connectorValidator;
    @NonnullAfterInit
    private T2 mappingStrategy;
    @Nullable
    private Cache<String, Map<String, IdPAttribute>> resultsCache;
    private boolean failFastInitialize;

    @NonnullAfterInit
    public ExecutableSearchBuilder<T1> getExecutableSearchBuilder() {
        return this.searchBuilder;
    }

    public void setExecutableSearchBuilder(@Nonnull ExecutableSearchBuilder<T1> builder) {
        this.checkSetterPreconditions();
        this.searchBuilder = (ExecutableSearchBuilder)Constraint.isNotNull(builder, (String)"Executable search builder cannot be null");
    }

    @NonnullAfterInit
    public Validator getValidator() {
        return this.connectorValidator;
    }

    public void setValidator(@Nonnull Validator validator) {
        this.checkSetterPreconditions();
        this.connectorValidator = (Validator)Constraint.isNotNull((Object)validator, (String)"Validator cannot be null");
    }

    @NonnullAfterInit
    public T2 getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(@Nonnull T2 strategy) {
        this.checkSetterPreconditions();
        this.mappingStrategy = (MappingStrategy)Constraint.isNotNull(strategy, (String)"Mapping strategy cannot be null");
    }

    @Nullable
    public Cache<String, Map<String, IdPAttribute>> getResultsCache() {
        return this.resultsCache;
    }

    public void setResultsCache(@Nullable Cache<String, Map<String, IdPAttribute>> cache) {
        this.checkSetterPreconditions();
        if (cache != null) {
            cache.invalidateAll();
        }
        this.resultsCache = cache;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected abstract Map<String, IdPAttribute> retrieveAttributes(@Nonnull T1 var1) throws ResolutionException;

    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull T1 executable, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        return this.retrieveAttributes(executable);
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        Map dependsAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies());
        ExecutableSearch executable = this.searchBuilder.build(resolutionContext, dependsAttributes);
        Map resolvedAttributes = null;
        Cache<String, Map<String, IdPAttribute>> cache = this.resultsCache;
        if (cache != null && resolutionContext.getAllowCachedResults()) {
            String cacheKey = executable.getResultCacheKey();
            if (cacheKey != null) {
                resolvedAttributes = (Map)cache.getIfPresent((Object)cacheKey);
                if (resolvedAttributes == null) {
                    this.log.debug("{} Cache key not found", (Object)this.getLogPrefix());
                    resolvedAttributes = this.retrieveAttributes(executable, workContext);
                    this.log.debug("{} Resolved attributes {}", (Object)this.getLogPrefix(), resolvedAttributes);
                    cache.put((Object)cacheKey, (Object)(resolvedAttributes != null ? resolvedAttributes : CollectionSupport.emptyMap()));
                } else if (resolvedAttributes.isEmpty()) {
                    this.log.debug("{} Cache key found empty (negative) result", (Object)this.getLogPrefix());
                } else {
                    this.log.debug("{} Cache key returned resolved attributes {}", (Object)this.getLogPrefix(), resolvedAttributes);
                }
            } else {
                this.log.debug("No cache key returned, skipping check for cached results");
                resolvedAttributes = this.retrieveAttributes(executable, workContext);
                this.log.debug("{} Resolved attributes: {}", (Object)this.getLogPrefix(), resolvedAttributes);
            }
        } else {
            resolvedAttributes = this.retrieveAttributes(executable, workContext);
            this.log.debug("{} Resolved attributes: {}", (Object)this.getLogPrefix(), resolvedAttributes);
        }
        return resolvedAttributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.searchBuilder == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No executable search builder was configured");
        }
        if (this.connectorValidator == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No validator was configured");
        }
        if (this.mappingStrategy == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No mapping strategy was configured");
        }
    }

    public boolean isFailFastInitialize() {
        return this.failFastInitialize;
    }

    public void setFailFastInitialize(boolean what) {
        this.failFastInitialize = what;
    }
}

