/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.http.HTTPResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.HTTPSearch;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public abstract class AbstractHTTPSearchBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<HTTPSearch> {
    @Nonnull
    @Unmodifiable
    private List<Pair<String, String>> headerList = CollectionSupport.emptyList();
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Pair<String, String>> getHeaders() {
        return this.headerList;
    }

    public void setHeaders(@Nonnull Map<String, String> headers) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(headers, (String)"Map of headers cannot be null");
        this.headerList = (List)((NonnullSupplier)headers.entrySet().stream().map(e -> new Pair((Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)e.getKey())), (String)"header name  must be non null")), (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)e.getValue())), (String)"header value must be non null")))).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @Nonnull
    public HTTPSearch build(final @Nonnull AttributeResolutionContext resolutionContext, final @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        final ClassicHttpRequest request = this.getHttpRequest(resolutionContext, dependencyAttributes);
        for (Pair<String, String> entry : this.headerList) {
            request.setHeader((String)entry.getFirst(), entry.getSecond());
        }
        return new HTTPSearch(){

            @Nullable
            public String getResultCacheKey() {
                return AbstractHTTPSearchBuilder.this.getResultCacheKey(request, resolutionContext, dependencyAttributes);
            }

            public String toString() {
                return request.getRequestUri();
            }

            @Nonnull
            public Map<String, IdPAttribute> execute(@Nonnull HttpClient client, @Nullable HttpClientSecurityParameters securityParameters, @Nonnull HTTPResponseMappingStrategy mappingStrategy) throws IOException {
                HttpClientContext clientContext = HttpClientSecuritySupport.buildHttpClientContext((HttpClientSecurityParameters)securityParameters);
                HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
                Map results = (Map)client.execute(request, (HttpContext)clientContext, (HttpClientResponseHandler)mappingStrategy);
                String scheme = request.getScheme();
                assert (scheme != null);
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
                assert (results != null);
                return results;
            }
        };
    }

    @Nonnull
    @NotEmpty
    protected String getURL(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        throw new UnsupportedOperationException("getURL method not overridden by subclass");
    }

    @Nonnull
    protected ClassicHttpRequest getHttpRequest(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        try {
            return new HttpGet(this.getURL(resolutionContext, dependencyAttributes));
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException((Exception)e);
        }
    }

    @Nullable
    protected String getResultCacheKey(@Nonnull ClassicHttpRequest request, @Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) {
        if (request instanceof HttpGet) {
            return request.getRequestUri();
        }
        return null;
    }
}

