/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationProcessingData;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;

public class ProcessAssertionsForAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessAssertionsForAuthentication.class);
    @Nonnull
    private Function<ProfileRequestContext, Response> responseResolver;
    @Nonnull
    private Function<ProfileRequestContext, SAMLAuthnContext> samlContextLookupStrategy;
    @Nonnull
    private BiConsumer<ProfileRequestContext, AuthnStatement> samlConsumer;
    @Nonnull
    private Function<List<Assertion>, Assertion> authnAssertionSelectionStrategy;
    @Nonnull
    private Function<Assertion, AuthnStatement> authnStatementSelectionStrategy;
    @NonnullBeforeExec
    private Response response;

    public ProcessAssertionsForAuthentication() {
        Function rr = new DefaultResponseResolver().compose(new ChildContextLookup(ProfileRequestContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class)));
        assert (rr != null);
        this.responseResolver = rr;
        Function scls = new ChildContextLookup(SAMLAuthnContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
        assert (scls != null);
        this.samlContextLookupStrategy = scls;
        this.samlConsumer = new DefaultSAMLConsumer();
        this.authnAssertionSelectionStrategy = assertions -> assertions.stream().filter(Objects::nonNull).sorted(Comparator.comparing(assertion -> assertion.getAuthnStatements().stream().filter(Objects::nonNull).map(AuthnStatement::getSessionNotOnOrAfter).filter(Objects::nonNull).sorted().findFirst().orElse(Instant.MAX))).findFirst().orElse(null);
        this.authnStatementSelectionStrategy = assertion -> assertion.getAuthnStatements().stream().filter(Objects::nonNull).sorted(Comparator.comparing(AuthnStatement::getSessionNotOnOrAfter, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().orElse(null);
    }

    public void setAuthnAssertionSelectionStrategy(@Nonnull Function<List<Assertion>, Assertion> strategy) {
        this.checkSetterPreconditions();
        this.authnAssertionSelectionStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication assertion selection strategy cannot be null");
    }

    public void setAuthnStatementSelectionStrategy(@Nonnull Function<Assertion, AuthnStatement> strategy) {
        this.checkSetterPreconditions();
        this.authnStatementSelectionStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication statement selection strategy cannot be null");
    }

    public void setResponseResolver(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.checkSetterPreconditions();
        this.responseResolver = (Function)Constraint.isNotNull(strategy, (String)"Response resolver strategy cannot be null");
    }

    public void setSAMLAuthnContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLAuthnContext> strategy) {
        this.checkSetterPreconditions();
        this.samlContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLAuthnContext lookup strategy cannot be null");
    }

    public void setSAMLConsumer(@Nonnull BiConsumer<ProfileRequestContext, AuthnStatement> consumer) {
        this.checkSetterPreconditions();
        this.samlConsumer = (BiConsumer)Constraint.isNotNull(consumer, (String)"BiConsumer cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.response = this.responseResolver.apply(profileRequestContext);
        if (this.response == null || this.response.getAssertions() == null || this.response.getAssertions().isEmpty()) {
            this.log.info("{} Profile context contained no candidate Assertions to process. Skipping further processing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        List nonValid = this.response.getAssertions().stream().filter(new AssertionIsValid().negate()).collect(Collectors.toList());
        this.log.debug("{} Removing {} non-valid Assertions from Response", (Object)this.getLogPrefix(), (Object)nonValid.size());
        this.response.getAssertions().removeAll(nonValid);
        Predicate<Assertion> selector = new AssertionContainsAuthenticationStatement().and(new AssertionContainsConfirmedSubject());
        List assertions = this.response.getAssertions().stream().filter(selector).collect(Collectors.toList());
        if (assertions.isEmpty()) {
            this.log.info("{} No valid SAML Assertions suitable for authentication were found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        Assertion authnAssertion = null;
        if (assertions.size() == 1) {
            authnAssertion = (Assertion)assertions.get(0);
            this.log.debug("{} Saw single suitable SAML Assertion, selecting for authentication", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Attempting to select from {} suitable SAML Assertions for authentication", (Object)this.getLogPrefix(), (Object)assertions.size());
            authnAssertion = this.authnAssertionSelectionStrategy.apply(assertions);
        }
        if (authnAssertion == null) {
            this.log.info("{} Could not select a single valid SAML Assertion for authentication", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        this.log.debug("{} Selected SAML Assertion for authentication: {}", (Object)this.getLogPrefix(), (Object)authnAssertion.getID());
        AuthnStatement authnStatement = null;
        if (authnAssertion.getAuthnStatements().size() == 1) {
            authnStatement = (AuthnStatement)authnAssertion.getAuthnStatements().get(0);
            this.log.debug("{} Saw single AuthnStatement, selecting for authentication", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Attempting to select from multiple AuthnStatements for authentication", (Object)this.getLogPrefix());
            authnStatement = this.authnStatementSelectionStrategy.apply(authnAssertion);
            if (authnStatement == null) {
                this.log.info("{} Could not select a single AuthnStatement for authentication", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
                return;
            }
        }
        this.samlConsumer.accept(profileRequestContext, authnStatement);
    }

    private final class DefaultResponseResolver
    implements Function<ProfileRequestContext, Response> {
        private DefaultResponseResolver() {
        }

        @Override
        @Nullable
        public Response apply(@Nullable ProfileRequestContext profileContext) {
            MessageContext imc;
            Object object;
            if (profileContext != null && (object = (imc = profileContext.ensureInboundMessageContext()).getMessage()) instanceof Response) {
                Response r = (Response)object;
                return r;
            }
            return null;
        }
    }

    private final class DefaultSAMLConsumer
    implements BiConsumer<ProfileRequestContext, AuthnStatement> {
        private DefaultSAMLConsumer() {
        }

        @Override
        public void accept(@Nullable ProfileRequestContext profileRequestContext, @Nullable AuthnStatement statement) {
            if (profileRequestContext == null || statement == null) {
                ProcessAssertionsForAuthentication.this.log.error("{} Inputs were null", (Object)ProcessAssertionsForAuthentication.this.getLogPrefix());
                return;
            }
            SAMLAuthnContext samlAuthnContext = ProcessAssertionsForAuthentication.this.samlContextLookupStrategy.apply(profileRequestContext);
            if (samlAuthnContext == null) {
                ProcessAssertionsForAuthentication.this.log.info("{} No SAMLAuthnContext available within authentication context", (Object)ProcessAssertionsForAuthentication.this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
                return;
            }
            samlAuthnContext.setAuthnStatement(statement);
            XMLObject xMLObject = statement.getParent();
            if (xMLObject instanceof Assertion) {
                Assertion assertion = (Assertion)xMLObject;
                samlAuthnContext.setSubject(assertion.getSubject());
            }
        }
    }

    private final class AssertionIsValid
    implements Predicate<Assertion> {
        private AssertionIsValid() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            Optional validationData = assertion.getObjectMetadata().get(ValidationProcessingData.class).stream().findFirst();
            if (validationData.isEmpty()) {
                return false;
            }
            return ((ValidationProcessingData)validationData.get()).getResult() == ValidationResult.VALID;
        }
    }

    private final class AssertionContainsAuthenticationStatement
    implements Predicate<Assertion> {
        private AssertionContainsAuthenticationStatement() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            return !assertion.getAuthnStatements().isEmpty();
        }
    }

    private final class AssertionContainsConfirmedSubject
    implements Predicate<Assertion> {
        private AssertionContainsConfirmedSubject() {
        }

        @Override
        public boolean test(@Nullable Assertion assertion) {
            if (assertion == null) {
                return false;
            }
            Optional validationData = assertion.getObjectMetadata().get(ValidationProcessingData.class).stream().findFirst();
            if (validationData.isEmpty()) {
                return false;
            }
            ValidationContext validationContext = ((ValidationProcessingData)validationData.get()).getContext();
            if (validationContext == null) {
                return false;
            }
            return validationContext.getDynamicParameters().get("saml2.ConfirmedSubjectConfirmation") != null;
        }
    }
}

