/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;

public class SingleLogoutProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration
implements net.shibboleth.saml.saml2.profile.config.SingleLogoutProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml2.logout";
    @Nonnull
    private Predicate<MessageContext> signSOAPRequestsPredicate;
    @Nonnull
    private Predicate<MessageContext> clientTLSSOAPRequestsPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> qualifiedNameIDFormatsLookupStrategy;

    public SingleLogoutProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml2/logout");
    }

    protected SingleLogoutProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignRequestsPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setEncryptNameIDsPredicate((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.signSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate();
        Predicate cltsrp = new NoIntegrityMessageChannelPredicate().negate();
        assert (cltsrp != null);
        this.clientTLSSOAPRequestsPredicate = cltsrp;
        this.qualifiedNameIDFormatsLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isSignSOAPRequests(@Nullable MessageContext messageContext) {
        return this.signSOAPRequestsPredicate.test(messageContext);
    }

    public void setSignSOAPRequests(boolean flag) {
        this.signSOAPRequestsPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setSignSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based signing cannot be null");
    }

    public boolean isClientTLSSOAPRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSSOAPRequestsPredicate.test(messageContext);
    }

    public void setClientTLSSOAPRequests(boolean flag) {
        this.clientTLSSOAPRequestsPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setClientTLSSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based client TLS use cannot be null");
    }

    @Nonnull
    @NotLive
    public Collection<String> getQualifiedNameIDFormats(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.qualifiedNameIDFormatsLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return CollectionSupport.copyToList(formats);
        }
        return CollectionSupport.emptyList();
    }

    public void setQualifiedNameIDFormats(@Nullable Collection<String> formats) {
        this.qualifiedNameIDFormatsLookupStrategy = formats == null || formats.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(formats)));
    }

    public void setQualifiedNameIDFormatsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.qualifiedNameIDFormatsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

