/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public abstract class BaseTransformingDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseTransformingDecoder.class);
    @Nonnull
    private List<Pair<Pattern, String>> transforms = CollectionSupport.emptyList();
    private boolean uppercase;
    private boolean lowercase;

    public void setUppercase(boolean flag) {
        this.checkSetterPreconditions();
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        this.checkSetterPreconditions();
        this.lowercase = flag;
    }

    public void setTransforms(@Nullable Collection<Pair<String, String>> newTransforms) {
        this.checkSetterPreconditions();
        if (newTransforms == null) {
            this.transforms = CollectionSupport.emptyList();
        } else {
            this.transforms = new ArrayList<Pair<Pattern, String>>();
            for (Pair<String, String> p : newTransforms) {
                Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
                this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
            }
        }
    }

    @Nullable
    protected String decode(@Nonnull @NotEmpty String id) {
        this.checkComponentActive();
        String s = id;
        if (this.lowercase) {
            this.log.debug("Converting input string '{}' to lowercase", (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.debug("Converting input string '{}' to uppercase", (Object)s);
            s = s.toUpperCase();
        }
        if (this.transforms.isEmpty()) {
            return s;
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Pattern first = (Pattern)Constraint.isNotNull((Object)((Pattern)p.getFirst()), (String)"Transforms did not contain pattern");
            Matcher m = first.matcher(s);
            this.log.debug("Applying replacement expression '{}' against input '{}'", (Object)first.pattern(), (Object)s);
            s = m.replaceAll((String)p.getSecond());
            this.log.debug("Result of replacement is '{}'", (Object)s);
        }
        return s;
    }
}

