/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusMessage;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class StatusMessageAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public StatusMessageAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof Response) {
                StatusMessage msg;
                Response r = (Response)response;
                Status status = r.getStatus();
                StatusMessage statusMessage = msg = status != null ? status.getStatusMessage() : null;
                if (msg != null) {
                    return msg.getValue();
                }
            } else if (response instanceof StatusResponseType) {
                org.opensaml.saml.saml2.core.StatusMessage msg;
                StatusResponseType srt = (StatusResponseType)response;
                org.opensaml.saml.saml2.core.Status status = srt.getStatus();
                org.opensaml.saml.saml2.core.StatusMessage statusMessage = msg = status != null ? status.getStatusMessage() : null;
                if (msg != null) {
                    return msg.getValue();
                }
            }
        }
        return null;
    }
}

