/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.audit.impl.AbstractScopingAuditExtractor;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Scoping;

public class ScopingIdPListAuditExtractor
extends AbstractScopingAuditExtractor<Collection<String>> {
    public ScopingIdPListAuditExtractor(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Collection<String> doApply(@Nullable Scoping scoping) {
        IDPList idpList;
        if (scoping != null && (idpList = scoping.getIDPList()) != null) {
            return idpList.getIDPEntrys().stream().map(IDPEntry::getProviderID).filter(s -> s != null).collect(Collectors.toUnmodifiableList());
        }
        return null;
    }
}

