/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.impl.ResolverTestRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class ResolverTestRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_PARAM = "principal";
    @Nonnull
    @NotEmpty
    public static final String REQUESTER_ID_PARAM = "requester";
    @Nonnull
    @NotEmpty
    public static final String ACS_INDEX_PARAM = "acsIndex";
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_PARAM = "protocol";
    @Nonnull
    @NotEmpty
    public static final String SAML1_PARAM = "saml1";
    @Nonnull
    @NotEmpty
    public static final String SAML2_PARAM = "saml2";
    @Nonnull
    @NotEmpty
    public static final String UNFILTERED_PARAM = "unfiltered";

    public ResolverTestRequestDecoder() {
        this.setProtocolMessageLoggerSubCategory("ADMIN");
    }

    protected void doDecode() throws MessageDecodingException {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            throw new MessageDecodingException("Unable to locate HttpServletRequest");
        }
        ResolverTestRequest message = new ResolverTestRequest(this.getPrincipal(request), this.getRequesterId(request), this.getIndex(request), this.getProtocol(request), this.getUnfiltered(request));
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)message);
        this.setMessageContext(messageContext);
        SAMLPeerEntityContext peerCtx = new SAMLPeerEntityContext();
        peerCtx.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        peerCtx.setEntityId(message.getRequesterId());
        messageContext.addSubcontext((BaseContext)peerCtx, true);
        if (message.getProtocol() != null) {
            ((SAMLProtocolContext)messageContext.ensureSubcontext(SAMLProtocolContext.class)).setProtocol(message.getProtocol());
        }
    }

    @Nonnull
    @NotEmpty
    protected String getPrincipal(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String name = StringSupport.trimOrNull((String)request.getParameter(PRINCIPAL_PARAM));
        if (name == null) {
            throw new MessageDecodingException("Request did not contain the principal query parameter.");
        }
        return name;
    }

    @Nonnull
    @NotEmpty
    protected String getRequesterId(@Nonnull HttpServletRequest request) throws MessageDecodingException {
        String name = StringSupport.trimOrNull((String)request.getParameter(REQUESTER_ID_PARAM));
        if (name == null) {
            throw new MessageDecodingException("Request did not contain the requester query parameter.");
        }
        return name;
    }

    @Nullable
    protected Integer getIndex(@Nonnull HttpServletRequest request) {
        String index = StringSupport.trimOrNull((String)request.getParameter(ACS_INDEX_PARAM));
        if (index != null) {
            return Integer.valueOf(index);
        }
        return null;
    }

    @Nullable
    protected String getProtocol(@Nonnull HttpServletRequest request) {
        String protocol = StringSupport.trimOrNull((String)request.getParameter(PROTOCOL_PARAM));
        if (protocol != null) {
            return protocol;
        }
        if (request.getParameter(SAML1_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:1.1:protocol";
        }
        if (request.getParameter(SAML2_PARAM) != null) {
            return "urn:oasis:names:tc:SAML:2.0:protocol";
        }
        return null;
    }

    @Nullable
    protected Boolean getUnfiltered(@Nonnull HttpServletRequest request) {
        return request.getParameter(UNFILTERED_PARAM) != null;
    }
}

