/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.RequestContext;

public final class ResolveAttributes
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolveAttributes.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> attributesLookupStrategy;
    @Nullable
    private Consumer<AttributeResolutionContext> resolutionContextDecorator;
    private boolean maskFailures;
    @Nullable
    private String resolutionLabel;
    private boolean createResolutionContext;
    @Nullable
    private AttributeResolvingProfileConfiguration profileConfiguration;

    public ResolveAttributes(@Nonnull ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
        this.issuerLookupStrategy = new IssuerLookupFunction();
        this.recipientLookupStrategy = new RelyingPartyIdLookupFunction();
        this.principalNameLookupStrategy = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
        this.attributeContextCreationStrategy = new ChildContextLookup(AttributeContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        this.attributesLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
        this.maskFailures = true;
        this.createResolutionContext = true;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.recipientLookupStrategy = strategy;
    }

    public void setPrincipalNameLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.principalNameLookupStrategy = strategy;
    }

    public void setAttributeContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext creation strategy cannot be null");
    }

    public void setAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.checkSetterPreconditions();
        this.attributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attributes lookup strategy cannot be null");
    }

    public void setAttributesToResolve(@Nonnull Collection<String> attributeIds) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(attributeIds, (String)"Attribute ID collection cannot be null");
        this.attributesLookupStrategy = FunctionSupport.constant((Object)StringSupport.normalizeStringCollection(attributeIds));
    }

    public void setResolutionContextDecorator(@Nullable Consumer<AttributeResolutionContext> decorator) {
        this.checkSetterPreconditions();
        this.resolutionContextDecorator = decorator;
    }

    public void setMaskFailures(boolean flag) {
        this.checkSetterPreconditions();
        this.maskFailures = flag;
    }

    public void setResolutionLabel(@Nullable String label) {
        this.checkSetterPreconditions();
        this.resolutionLabel = StringSupport.trimOrNull((String)label);
    }

    public void setCreateResolutionContext(boolean flag) {
        this.checkSetterPreconditions();
        this.createResolutionContext = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext ctx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.resolutionLabel == null) {
            RequestContext requestContext;
            SpringRequestContext springContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            RequestContext requestContext2 = requestContext = springContext != null ? springContext.getRequestContext() : null;
            if (requestContext != null) {
                this.resolutionLabel = requestContext.getActiveFlow().getId();
            }
        }
        if ((ctx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext)) != null && (profileConfiguration = ctx.getProfileConfig()) instanceof AttributeResolvingProfileConfiguration) {
            AttributeResolvingProfileConfiguration pc;
            this.profileConfiguration = pc = (AttributeResolvingProfileConfiguration)profileConfiguration;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        block15: {
            AttributeResolutionContext resolutionContext;
            if (this.createResolutionContext) {
                resolutionContext = (AttributeResolutionContext)profileRequestContext.ensureSubcontext(AttributeResolutionContext.class);
                this.populateResolutionContext(profileRequestContext, resolutionContext);
            } else {
                resolutionContext = (AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class);
                if (resolutionContext == null) {
                    this.log.error("{} Unable to locate AttributeResolutionContext", (Object)this.getLogPrefix());
                    if (!this.maskFailures) {
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
                    }
                    return;
                }
            }
            try (ServiceableComponent component = this.attributeResolverService.getServiceableComponent();){
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                attributeResolver.resolveAttributes(resolutionContext);
                profileRequestContext.removeSubcontext((BaseContext)resolutionContext);
                AttributeContext attributeCtx = this.attributeContextCreationStrategy.apply(profileRequestContext);
                if (null == attributeCtx) {
                    throw new ResolutionException("Unable to create or locate AttributeContext to populate");
                }
                attributeCtx.setIdPAttributes(resolutionContext.getResolvedIdPAttributes());
                attributeCtx.setUnfilteredIdPAttributes(resolutionContext.getResolvedIdPAttributes());
            }
            catch (ResolutionException e) {
                this.log.error("{} Error resolving attributes", (Object)this.getLogPrefix(), (Object)e);
                if (!this.maskFailures) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
                }
            }
            catch (ServiceException e) {
                this.log.error("{} Invalid AttributeResolver configuration", (Object)this.getLogPrefix(), (Object)e);
                if (this.maskFailures) break block15;
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToResolveAttributes");
            }
        }
    }

    private void populateResolutionContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeResolutionContext resolutionContext) {
        AttributeResolvingProfileConfiguration arpc;
        String groupId;
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext rpContext;
        resolutionContext.setResolutionLabel(this.resolutionLabel);
        if (resolutionContext.getRequestedIdPAttributeNames() == null || resolutionContext.getRequestedIdPAttributeNames().isEmpty()) {
            assert (this.attributesLookupStrategy != null);
            Collection<String> names = this.attributesLookupStrategy.apply(profileRequestContext);
            if (names != null && !names.isEmpty()) {
                resolutionContext.setRequestedIdPAttributeNames(names);
            } else if (this.profileConfiguration != null) {
                resolutionContext.setRequestedIdPAttributeNames(this.profileConfiguration.getRequestedIdPAttributeNames(profileRequestContext));
            }
        }
        if (null != this.principalNameLookupStrategy) {
            resolutionContext.setPrincipal(this.principalNameLookupStrategy.apply(profileRequestContext));
        } else {
            resolutionContext.setPrincipal(null);
        }
        if (this.recipientLookupStrategy != null) {
            resolutionContext.setAttributeRecipientID(this.recipientLookupStrategy.apply(profileRequestContext));
        } else {
            resolutionContext.setAttributeRecipientID(null);
        }
        if (this.issuerLookupStrategy != null) {
            resolutionContext.setAttributeIssuerID(this.issuerLookupStrategy.apply(profileRequestContext));
        } else {
            resolutionContext.setAttributeIssuerID(null);
        }
        if (this.resolutionContextDecorator != null) {
            this.resolutionContextDecorator.accept(resolutionContext);
        }
        if ((rpContext = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class)) != null && (profileConfiguration = rpContext.getProfileConfig()) instanceof AttributeResolvingProfileConfiguration && (groupId = (arpc = (AttributeResolvingProfileConfiguration)profileConfiguration).getAttributeRecipientGroupID(profileRequestContext)) != null) {
            resolutionContext.setAttributeRecipientGroupID(groupId);
        }
    }
}

