/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.ScriptedPredicate;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.ScriptTypeBeanParser;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.profile.logic.EntityIdPredicate;
import org.opensaml.saml.common.profile.logic.EntityRegexPredicate;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.metadata.resolver.filter.impl.AlgorithmFilter;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AlgorithmFilterParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "Algorithm");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AlgorithmFilterParser.class);

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return AlgorithmFilter.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        ManagedList forRule;
        BeanDefinitionBuilder entityIdBuilder;
        super.doParse(element, parserContext, builder);
        Unmarshaller digestUnmarshaller = XMLObjectSupport.getUnmarshaller((QName)DigestMethod.DEFAULT_ELEMENT_NAME);
        Unmarshaller signingUnmarshaller = XMLObjectSupport.getUnmarshaller((QName)SigningMethod.DEFAULT_ELEMENT_NAME);
        Unmarshaller encryptionUnmarshaller = XMLObjectSupport.getUnmarshaller((QName)EncryptionMethod.DEFAULT_ELEMENT_NAME);
        if (digestUnmarshaller == null || signingUnmarshaller == null || encryptionUnmarshaller == null) {
            throw new BeanCreationException("Unable to obtain Unmarshallers");
        }
        ArrayList<XMLObject> accumulator = new ArrayList<XMLObject>();
        ManagedMap ruleMap = new ManagedMap();
        ManagedSet entitySet = new ManagedSet();
        Element child = ElementSupport.getFirstChildElement((Node)element);
        while (child != null) {
            if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"Entity")) {
                entitySet.add((Object)ElementSupport.getElementContentAsString((Element)child));
                child = ElementSupport.getNextSiblingElement((Node)child);
                continue;
            }
            if (!entitySet.isEmpty()) {
                entityIdBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
                entityIdBuilder.addConstructorArgValue((Object)entitySet);
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)entityIdBuilder.getBeanDefinition(), (Object)forRule);
                entitySet = new ManagedSet();
            }
            if (ElementSupport.isElementNamed((Element)child, (QName)DigestMethod.DEFAULT_ELEMENT_NAME)) {
                try {
                    accumulator.add(digestUnmarshaller.unmarshall(child));
                }
                catch (UnmarshallingException e) {
                    this.log.error("Error unmarshalling DigestMethod element", (Throwable)e);
                }
            } else if (ElementSupport.isElementNamed((Element)child, (QName)SigningMethod.DEFAULT_ELEMENT_NAME)) {
                try {
                    accumulator.add(signingUnmarshaller.unmarshall(child));
                }
                catch (UnmarshallingException e) {
                    this.log.error("Error unmarshalling SigningMethod element", (Throwable)e);
                }
            } else if (ElementSupport.isElementNamed((Element)child, (QName)EncryptionMethod.DEFAULT_ELEMENT_NAME)) {
                try {
                    accumulator.add(encryptionUnmarshaller.unmarshall(child));
                }
                catch (UnmarshallingException e) {
                    this.log.error("Error unmarshalling EncryptionMethod element", (Throwable)e);
                }
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"EntityRegex")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                BeanDefinitionBuilder expBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityRegexPredicate.class);
                expBuilder.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)child));
                ruleMap.put((Object)expBuilder.getBeanDefinition(), (Object)forRule);
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"ConditionRef")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)new RuntimeBeanReference(ElementSupport.getElementContentAsString((Element)child)), (Object)forRule);
            } else if (ElementSupport.isElementNamed((Element)child, (String)"urn:mace:shibboleth:2.0:metadata", (String)"ConditionScript")) {
                forRule = new ManagedList(accumulator.size());
                forRule.addAll(accumulator);
                ruleMap.put((Object)ScriptTypeBeanParser.parseScriptType(ScriptedPredicate.class, child).getBeanDefinition(), (Object)forRule);
            }
            child = ElementSupport.getNextSiblingElement((Node)child);
        }
        if (!entitySet.isEmpty()) {
            entityIdBuilder = BeanDefinitionBuilder.genericBeanDefinition(EntityIdPredicate.class);
            entityIdBuilder.addConstructorArgValue((Object)entitySet);
            forRule = new ManagedList(accumulator.size());
            forRule.addAll(accumulator);
            ruleMap.put((Object)entityIdBuilder.getBeanDefinition(), (Object)forRule);
        }
        builder.addPropertyValue("rules", (Object)ruleMap);
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

