/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.spring.metadata.AbstractMetadataProviderParser;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadingMetadataProviderParser
extends AbstractMetadataProviderParser {
    @Nullable
    private final String parserPoolRef = AbstractReloadingMetadataProviderParser.getCustomProperty((String)(AbstractReloadingMetadataProviderParser.class.getName() + ".ParserPool.bean"), null);

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String timerRef = this.getTaskTimerRef(element);
        if (timerRef != null) {
            builder.addConstructorArgReference(timerRef);
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
        if (element.hasAttributeNS(null, "indexesRef")) {
            builder.addPropertyReference("indexes", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"indexesRef"));
        }
        if (element.hasAttributeNS(null, "resolveViaPredicatesOnly")) {
            builder.addPropertyValue("resolveViaPredicatesOnly", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "resolveViaPredicatesOnly")));
        }
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "refreshDelayFactor")));
        }
        if (element.hasAttributeNS(null, "maxRefreshDelay")) {
            builder.addPropertyValue("maxRefreshDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxRefreshDelay")));
        }
        if (element.hasAttributeNS(null, "minRefreshDelay")) {
            builder.addPropertyValue("minRefreshDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "minRefreshDelay")));
        }
        if (element.hasAttributeNS(null, "expirationWarningThreshold")) {
            builder.addPropertyValue("expirationWarningThreshold", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "expirationWarningThreshold")));
        }
    }

    @Nullable
    protected String getTaskTimerRef(Element element) {
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            return AttributeSupport.ensureAttributeValue((Element)element, null, (String)"taskTimerRef");
        }
        return null;
    }

    @Nonnull
    @NotEmpty
    protected String getParserPoolRef(Element element) {
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            return AttributeSupport.ensureAttributeValue((Element)element, null, (String)"parserPoolRef");
        }
        if (this.parserPoolRef != null) {
            return this.parserPoolRef;
        }
        throw new BeanCreationException("Default ParserPool bean ID not available.");
    }
}

