/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.spring.metadata.AbstractMetadataProviderParser;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDynamicMetadataProviderParser
extends AbstractMetadataProviderParser {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataProviderParser.class);
    @Nullable
    private final String parserPoolRef = AbstractDynamicMetadataProviderParser.getCustomProperty((String)(AbstractDynamicMetadataProviderParser.class.getName() + ".ParserPool.bean"), null);

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);
        String timerRef = this.getTaskTimerRef(element);
        if (timerRef != null) {
            builder.addConstructorArgReference(timerRef);
        }
        this.processTimingProperties(element, parserContext, builder);
        if (element.hasAttributeNS(null, "expirationWarningThreshold")) {
            builder.addPropertyValue("expirationWarningThreshold", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "expirationWarningThreshold")));
        }
        if (element.hasAttributeNS(null, "indexesRef")) {
            builder.addPropertyReference("indexes", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"indexesRef"));
        }
        builder.addPropertyReference("parserPool", this.getParserPoolRef(element));
        this.processPersistentCachingProperties(element, parserContext, builder);
    }

    protected void processTimingProperties(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (element.hasAttributeNS(null, "refreshDelayFactor")) {
            builder.addPropertyValue("refreshDelayFactor", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "refreshDelayFactor")));
        }
        if (element.hasAttributeNS(null, "minCacheDuration")) {
            builder.addPropertyValue("minCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "minCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxCacheDuration")) {
            builder.addPropertyValue("maxCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxCacheDuration")));
        }
        if (element.hasAttributeNS(null, "negativeLookupCacheDuration")) {
            builder.addPropertyValue("negativeLookupCacheDuration", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "negativeLookupCacheDuration")));
        }
        if (element.hasAttributeNS(null, "maxIdleEntityData")) {
            builder.addPropertyValue("maxIdleEntityData", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "maxIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "removeIdleEntityData")) {
            builder.addPropertyValue("removeIdleEntityData", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "removeIdleEntityData")));
        }
        if (element.hasAttributeNS(null, "cleanupTaskInterval")) {
            builder.addPropertyValue("cleanupTaskInterval", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "cleanupTaskInterval")));
        }
    }

    protected void processPersistentCachingProperties(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (element.hasAttributeNS(null, "persistentCacheManagerRef")) {
            builder.addPropertyReference("persistentCacheManager", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"persistentCacheManagerRef"));
            if (element.hasAttributeNS(null, "persistentCacheManagerDirectory")) {
                this.log.warn("{} Element contained both persistentCacheManagerRef and persistentCacheManagerDirectory, persistentCacheManagerDirectory will be ignored", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
        } else if (element.hasAttributeNS(null, "persistentCacheManagerDirectory")) {
            String cacheDirectory = StringSupport.trimOrNull((String)element.getAttributeNS(null, "persistentCacheManagerDirectory"));
            this.log.debug("{} Building internally-constructed FilesystemLoadSaveManager with base directory: {}", (Object)parserContext.getReaderContext().getResource().getDescription(), (Object)cacheDirectory);
            BeanDefinitionBuilder cacheManagerBuilder = BeanDefinitionBuilder.genericBeanDefinition(FilesystemLoadSaveManager.class);
            cacheManagerBuilder.addConstructorArgValue((Object)cacheDirectory);
            builder.addPropertyValue("persistentCacheManager", (Object)cacheManagerBuilder.getBeanDefinition());
        }
        if (element.hasAttributeNS(null, "persistentCacheKeyGeneratorRef")) {
            builder.addPropertyReference("persistentCacheKeyGenerator", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"persistentCacheKeyGeneratorRef"));
        }
        if (element.hasAttributeNS(null, "initializeFromPersistentCacheInBackground")) {
            builder.addPropertyValue("initializeFromPersistentCacheInBackground", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "initializeFromPersistentCacheInBackground")));
        }
        if (element.hasAttributeNS(null, "backgroundInitializationFromCacheDelay")) {
            builder.addPropertyValue("backgroundInitializationFromCacheDelay", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "backgroundInitializationFromCacheDelay")));
        }
        if (element.hasAttributeNS(null, "initializationFromCachePredicateRef")) {
            builder.addPropertyReference("initializationFromCachePredicate", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"initializationFromCachePredicateRef"));
        }
    }

    @Nullable
    protected String getTaskTimerRef(@Nonnull Element element) {
        if (element.hasAttributeNS(null, "taskTimerRef")) {
            return AttributeSupport.ensureAttributeValue((Element)element, null, (String)"taskTimerRef");
        }
        return null;
    }

    @Nonnull
    @NotEmpty
    protected String getParserPoolRef(@Nonnull Element element) {
        if (element.hasAttributeNS(null, "parserPoolRef")) {
            return AttributeSupport.ensureAttributeValue((Element)element, null, (String)"parserPoolRef");
        }
        if (this.parserPoolRef != null) {
            return this.parserPoolRef;
        }
        throw new BeanCreationException("Default ParserPool bean ID not available.");
    }
}

