/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.relyingparty;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;

public class RelyingPartyCredentialResolver
implements CredentialResolver,
IdentifiableComponent {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RelyingPartyCredentialResolver.class);
    @Nonnull
    private ReloadableService<RelyingPartyConfigurationResolver> service;
    @Nullable
    private String id;

    public RelyingPartyCredentialResolver(@Nonnull ReloadableService<RelyingPartyConfigurationResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"ReloadableSpringService for RelyingPartyConfigurationResolver cannot be null");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull @NotEmpty String componentId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)componentId), (String)"Component ID can not be null or empty");
    }

    @Nullable
    public Credential resolveSingle(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        Iterable<Credential> creds = this.resolve(criteriaSet);
        if (creds.iterator().hasNext()) {
            return creds.iterator().next();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Iterable<Credential> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        UsageCriterion usage = criteria != null ? (UsageCriterion)criteria.get(UsageCriterion.class) : null;
        try (ServiceableComponent component = this.service.getServiceableComponent();){
            RelyingPartyConfigurationResolver resolver = (RelyingPartyConfigurationResolver)component.getComponent();
            if (usage != null) {
                if (UsageType.SIGNING.equals((Object)usage.getUsage())) {
                    Collection<Credential> collection = resolver.getSigningCredentials();
                    return collection;
                }
                if (UsageType.ENCRYPTION.equals((Object)usage.getUsage())) {
                    Collection<Credential> collection = resolver.getEncryptionCredentials();
                    return collection;
                }
            }
            ArrayList<Credential> combined = new ArrayList<Credential>();
            combined.addAll(resolver.getSigningCredentials());
            combined.addAll(resolver.getEncryptionCredentials());
            ArrayList<Credential> arrayList = combined;
            return arrayList;
        }
        catch (ServiceException e) {
            this.log.error("CredentialsResolver '{}': Invalid RelyingPartyResolver configuration", (Object)this.getId(), (Object)e);
            return CollectionSupport.emptyList();
        }
    }
}

