/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class RelyingPartyContext
extends BaseContext {
    @Nullable
    private Boolean verified;
    @Nullable
    private String relyingPartyId;
    @Nullable
    private BaseContext relyingPartyIdContextTree;
    @Nullable
    private Function<RelyingPartyContext, Boolean> verificationLookupStrategy;
    @Nullable
    private Function<RelyingPartyContext, String> relyingPartyIdLookupStrategy;
    @Nullable
    private RelyingPartyConfiguration relyingPartyConfiguration;
    @Nullable
    private ProfileConfiguration profileConfiguration;

    public boolean isVerified() {
        Boolean flag;
        if (this.verified != null) {
            return this.verified;
        }
        if (this.verificationLookupStrategy != null && (flag = this.verificationLookupStrategy.apply(this)) != null) {
            return flag;
        }
        return false;
    }

    @Nonnull
    public RelyingPartyContext setVerified(@Nullable Boolean flag) {
        this.verified = flag;
        return this;
    }

    @Nullable
    public String getRelyingPartyId() {
        if (this.relyingPartyId != null) {
            return this.relyingPartyId;
        }
        if (this.relyingPartyIdLookupStrategy != null) {
            return this.relyingPartyIdLookupStrategy.apply(this);
        }
        return null;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyId(@Nullable String rpId) {
        this.relyingPartyId = StringSupport.trimOrNull((String)rpId);
        return this;
    }

    @Nullable
    public BaseContext getRelyingPartyIdContextTree() {
        return this.relyingPartyIdContextTree;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyIdContextTree(@Nullable BaseContext root) {
        this.relyingPartyIdContextTree = root;
        return this;
    }

    @Nullable
    Function<RelyingPartyContext, Boolean> getVerificationLookupStrategy() {
        return this.verificationLookupStrategy;
    }

    @Nonnull
    public RelyingPartyContext setVerificationLookupStrategy(@Nonnull Function<RelyingPartyContext, Boolean> strategy) {
        this.verificationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
        return this;
    }

    @Nullable
    Function<RelyingPartyContext, String> getRelyingPartyIdLookupStrategy() {
        return this.relyingPartyIdLookupStrategy;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyIdLookupStrategy(@Nonnull Function<RelyingPartyContext, String> strategy) {
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
        return this;
    }

    @Nullable
    public RelyingPartyConfiguration getConfiguration() {
        return this.relyingPartyConfiguration;
    }

    @Nonnull
    public RelyingPartyConfiguration ensureConfiguration() {
        if (this.relyingPartyConfiguration != null) {
            return this.relyingPartyConfiguration;
        }
        throw new IllegalStateException("RelyingPartyConfiguration was null");
    }

    @Nonnull
    public RelyingPartyContext setConfiguration(@Nullable RelyingPartyConfiguration config) {
        this.relyingPartyConfiguration = config;
        return this;
    }

    @Nullable
    public ProfileConfiguration getProfileConfig() {
        return this.profileConfiguration;
    }

    @Nonnull
    public ProfileConfiguration ensureProfileConfig() {
        if (this.profileConfiguration != null) {
            return this.profileConfiguration;
        }
        throw new IllegalStateException("ProfileConfiguration was null");
    }

    @Nonnull
    public RelyingPartyContext setProfileConfig(@Nullable ProfileConfiguration config) {
        this.profileConfiguration = config;
        return this;
    }
}

