/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.security;

import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.xmlobject.KeyAuthority;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;

public final class KeyAuthoritySupport {
    public static final int KEY_AUTHORITY_VERIFY_DEPTH_DEFAULT = 1;

    private KeyAuthoritySupport() {
    }

    @Nullable
    public static PKIXValidationInformation extractPKIXValidationInfo(@Nullable KeyAuthority keyAuthority) throws SecurityException {
        List<KeyInfo> keyInfos;
        if (keyAuthority == null) {
            return null;
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        Integer depth = keyAuthority.getVerifyDepth();
        if (depth == null) {
            depth = 1;
        }
        if ((keyInfos = keyAuthority.getKeyInfos()) == null || keyInfos.isEmpty()) {
            return null;
        }
        for (KeyInfo keyInfo : keyInfos) {
            certs.addAll(KeyAuthoritySupport.getX509Certificates(keyInfo));
            crls.addAll(KeyAuthoritySupport.getX509CRLs(keyInfo));
        }
        if (certs.isEmpty() && crls.isEmpty()) {
            return null;
        }
        return new KeyAuthorityPKIXValidationInformation(certs, crls, depth);
    }

    @Nonnull
    @Live
    private static Collection<X509Certificate> getX509Certificates(@Nullable KeyInfo keyInfo) throws SecurityException {
        try {
            return KeyInfoSupport.getCertificates((KeyInfo)keyInfo);
        }
        catch (CertificateException e) {
            throw new SecurityException("Error extracting certificates from KeyAuthority KeyInfo", (Exception)e);
        }
    }

    @Nonnull
    @Live
    private static Collection<X509CRL> getX509CRLs(@Nullable KeyInfo keyInfo) throws SecurityException {
        try {
            return KeyInfoSupport.getCRLs((KeyInfo)keyInfo);
        }
        catch (CRLException e) {
            throw new SecurityException("Error extracting CRL's from KeyAuthority KeyInfo", (Exception)e);
        }
    }

    public static class KeyAuthorityPKIXValidationInformation
    implements PKIXValidationInformation {
        @Nullable
        private final Collection<X509Certificate> trustAnchors;
        @Nullable
        private final Collection<X509CRL> trustedCRLs;
        @Nonnull
        private final Integer verificationDepth;

        public KeyAuthorityPKIXValidationInformation(@Nullable Collection<X509Certificate> anchors, @Nullable Collection<X509CRL> crls, @Nonnull Integer depth) {
            this.verificationDepth = (Integer)Constraint.isNotNull((Object)depth, (String)"Verification depth cannot be null");
            this.trustAnchors = anchors != null ? (Collection)anchors.stream().filter(e -> e != null).collect(Collectors.toUnmodifiableList()) : null;
            this.trustedCRLs = crls != null ? (Collection)crls.stream().filter(e -> e != null).collect(Collectors.toUnmodifiableList()) : null;
        }

        @Nullable
        @Unmodifiable
        @NotLive
        public Collection<X509CRL> getCRLs() {
            return this.trustedCRLs;
        }

        @Nullable
        @Unmodifiable
        @NotLive
        public Collection<X509Certificate> getCertificates() {
            return this.trustAnchors;
        }

        @Nonnull
        public Integer getVerificationDepth() {
            return this.verificationDepth;
        }
    }
}

