/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.opensaml.saml.saml2.metadata.LocalizedURI;
import org.opensaml.saml.saml2.metadata.Organization;
import org.slf4j.Logger;

public class OrganizationUIInfo {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationUIInfo.class);
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> organizationNames;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> displayNames;
    @Nonnull
    @Unmodifiable
    @NotLive
    private final Map<Locale, String> urls;
    @Nonnull
    private final Predicate<LocalizedName> nullLanguageString = new Predicate<LocalizedName>(){

        @Override
        public boolean test(LocalizedName u) {
            if (u.getXMLLang() == null) {
                LOG.warn("String with value {} in <{}> has no language associated, ignoring", (Object)u.getValue(), (Object)u.getElementQName().getLocalPart());
                return false;
            }
            if (u.getValue() == null) {
                LOG.warn("Ignoring empty <{}> element", (Object)u.getElementQName().getLocalPart());
                return false;
            }
            return true;
        }
    };
    @Nonnull
    private final Predicate<LocalizedURI> nullLanguageURL = new Predicate<LocalizedURI>(){

        @Override
        public boolean test(LocalizedURI u) {
            if (u.getXMLLang() == null) {
                LOG.warn("URL with value {} in <{}> has no language associated, ignoring", (Object)u.getURI(), (Object)u.getElementQName().getLocalPart());
                return false;
            }
            if (u.getURI() == null) {
                LOG.warn("Ignoring empty <{}> element", (Object)u.getElementQName().getLocalPart());
                return false;
            }
            return true;
        }
    };

    public OrganizationUIInfo(@Nonnull Organization organization) {
        this.organizationNames = (Map)((NonnullSupplier)organization.getOrganizationNames().stream().filter(this.nullLanguageString).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(serviceName -> Locale.forLanguageTag(serviceName.getXMLLang()), serviceName -> serviceName.getValue(), CollectionSupport.warningMergeFunction((String)"OrganizationUIInfo OrganizationName", (boolean)false))))).get();
        this.displayNames = (Map)((NonnullSupplier)organization.getDisplayNames().stream().filter(this.nullLanguageString).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(description -> Locale.forLanguageTag(description.getXMLLang()), description -> description.getValue(), CollectionSupport.warningMergeFunction((String)"OrganizationUIInfo DisplayNames", (boolean)false))))).get();
        this.urls = (Map)((NonnullSupplier)organization.getURLs().stream().filter(this.nullLanguageURL).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), dn -> dn.getURI(), CollectionSupport.warningMergeFunction((String)"OrganizationUIInfo URL", (boolean)false))))).get();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getOrganizationNames() {
        return this.organizationNames;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getOrganizationDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Locale, String> getOrganizationUrls() {
        return this.urls;
    }
}

