/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.logic.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.logic.impl.AbstractComposedPolicyRule;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class OrPolicyRule
extends AbstractComposedPolicyRule {
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getComposedRules().isEmpty()) {
            throw new ComponentInitializationException("No policy rules supplied to OR");
        }
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        this.checkComponentActive();
        List<PolicyRequirementRule> rules = this.getComposedRules();
        for (PolicyRequirementRule rule : rules) {
            PolicyRequirementRule.Tristate match = rule.matches(filterContext);
            if (PolicyRequirementRule.Tristate.FAIL == match) {
                return PolicyRequirementRule.Tristate.FAIL;
            }
            if (PolicyRequirementRule.Tristate.TRUE != match) continue;
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

