/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.FilterScriptContextExtender;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class ScriptedMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedMatcher.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private MatcherScriptEvaluator scriptEvaluator;
    @Nonnull
    private Collection<FilterScriptContextExtender> contextExtenders = CollectionSupport.emptyList();
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript matcherScript) {
        this.checkSetterPreconditions();
        this.script = (EvaluableScript)Constraint.isNotNull((Object)matcherScript, (String)"Attribute value matching script cannot be null");
    }

    public void setScriptContextExtenders(@Nullable Collection<FilterScriptContextExtender> extenders) {
        this.checkSetterPreconditions();
        this.contextExtenders = extenders != null ? CollectionSupport.copyToList(extenders) : CollectionSupport.emptyList();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException("No script has been provided");
        }
        assert (this.script != null);
        this.scriptEvaluator = new MatcherScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setContextExtenders(this.contextExtenders);
        StringBuilder builder = new StringBuilder("Scripted Attribute Filter '").append(this.getId()).append("':");
        this.scriptEvaluator.setLogPrefix(builder.toString());
    }

    @Nullable
    @Unmodifiable
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered cannot be null");
        Constraint.isNotNull((Object)filterContext, (String)"AttributeFilterContext cannot be null");
        this.checkComponentActive();
        return this.scriptEvaluator.execute(attribute, filterContext);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScriptedMatcher)) {
            return false;
        }
        ScriptedMatcher other = (ScriptedMatcher)((Object)obj);
        return this.script.equals(other.getScript());
    }

    public int hashCode() {
        return Objects.hash(this.script, this.getId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Script", (Object)this.getScript()).toString();
    }

    private class MatcherScriptEvaluator
    extends AbstractScriptEvaluator {
        public MatcherScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
            this.setOutputType(Set.class);
            this.setHideExceptions(true);
        }

        @Nullable
        @Unmodifiable
        @NotLive
        public Set<IdPAttributeValue> execute(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
            Object result = this.evaluate(new Object[]{attribute, filterContext});
            if (null == result) {
                ScriptedMatcher.this.log.error("{} Matcher script did not return a result", (Object)this.getLogPrefix());
                return null;
            }
            LinkedHashSet returnValues = new LinkedHashSet(attribute.getValues());
            returnValues.retainAll((Set)result);
            return CollectionSupport.copyToSet(returnValues);
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            if (input != null) {
                scriptContext.setAttribute("attribute", input[0], 100);
                scriptContext.setAttribute("filterContext", input[1], 100);
                ProfileRequestContext prc = (ProfileRequestContext)((AttributeFilterContext)input[1]).getProfileRequestContextLookupStrategy().apply((AttributeFilterContext)input[1]);
                scriptContext.setAttribute("profileContext", prc, 100);
            } else {
                ScriptedMatcher.this.log.error("{} Script invoked with null inputs", (Object)this.getLogPrefix());
            }
        }
    }
}

