/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.BaseBridgingClass;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public final class PolicyFromMatcherId
extends BaseBridgingClass
implements PolicyRequirementRule,
IdentifiedComponent,
DestructableComponent {
    @Nonnull
    private final Matcher theMatcher;
    @Nonnull
    @NotEmpty
    private final String attributeId;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PolicyFromMatcherId.class);

    public PolicyFromMatcherId(@Nonnull @ParameterName(name="matcher") Matcher matcher, @Nonnull @ParameterName(name="attribute") @NotEmpty String attribute) {
        super(matcher);
        this.theMatcher = matcher;
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attribute), (String)"attribute must not be null or empty");
    }

    @Nonnull
    public String getAttributeId() {
        return this.attributeId;
    }

    @Nonnull
    public Matcher getMatcher() {
        return this.theMatcher;
    }

    @Override
    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext context) {
        this.log.debug("{} Applying matcher supplied as policy to all values of attribute {}", (Object)this.getLogPrefix(), (Object)this.attributeId);
        IdPAttribute attribute = context.getPrefilteredIdPAttributes().get(this.attributeId);
        if (null == attribute) {
            this.log.debug("{} No attribute found with Id of {}", (Object)this.getLogPrefix(), (Object)this.attributeId);
            return PolicyRequirementRule.Tristate.FALSE;
        }
        Set<IdPAttributeValue> result = this.theMatcher.getMatchingValues(attribute, context);
        if (null == result) {
            this.log.warn("{} Matcher returned null, returning FAIL", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FAIL;
        }
        if (!result.isEmpty()) {
            this.log.debug("{} Matcher returned some values.  Return TRUE", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Matcher returned no values for the attribute {}.  Return FALSE", (Object)this.getLogPrefix(), (Object)this.attributeId);
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

