/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.logic.Constraint;

public abstract class BaseBridgingClass
extends AbstractIdentifiableInitializableComponent
implements IdentifiableComponent,
DestructableComponent {
    @Nonnull
    private final Object bridgedObject;
    @Nullable
    private String logPrefix;

    public BaseBridgingClass(@Nonnull @ParameterName(name="base") Object base) {
        this.bridgedObject = Constraint.isNotNull((Object)base, (String)"base rule can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.bridgedObject instanceof InitializableComponent) {
            ((InitializableComponent)this.bridgedObject).initialize();
        }
        super.doInitialize();
        this.logPrefix = null;
    }

    protected void doDestroy() {
        if (this.bridgedObject instanceof DestructableComponent) {
            ((DestructableComponent)this.bridgedObject).destroy();
        }
        super.doDestroy();
    }

    protected String getLogPrefix() {
        String result = this.logPrefix;
        if (null == result) {
            this.logPrefix = result = new StringBuffer("Bridging for class '").append(this.getId()).append("' ").toString();
        }
        return result;
    }
}

