/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.saml1.profile.config.AttributeQueryProfileConfiguration;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;

public class IncludeAttributeStatementPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = new ChildContextLookup(SAMLBindingContext.class).compose((Function)new OutboundMessageContextLookup());

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        if (this.isArtifactBinding(input)) {
            return true;
        }
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null) {
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof BrowserSSOProfileConfiguration) {
                BrowserSSOProfileConfiguration sso = (BrowserSSOProfileConfiguration)pc;
                return sso.isIncludeAttributeStatement(input);
            }
            if (pc instanceof AttributeQueryProfileConfiguration) {
                return true;
            }
            if (pc instanceof net.shibboleth.saml.saml2.profile.config.AttributeQueryProfileConfiguration) {
                return true;
            }
        }
        return false;
    }

    private boolean isArtifactBinding(@Nullable ProfileRequestContext profileRequestContext) {
        BindingDescriptor bd;
        SAMLBindingContext bindingCtx = this.bindingContextLookupStrategy.apply(profileRequestContext);
        if (bindingCtx != null && (bd = bindingCtx.getBindingDescriptor()) != null) {
            return bd.isArtifact();
        }
        return false;
    }
}

