/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.PropertiesWithComments;
import net.shibboleth.idp.installer.impl.CurrentInstallState;
import net.shibboleth.idp.installer.impl.InstalledMetadataParameters;
import net.shibboleth.idp.installer.impl.InstallerPropertiesImpl;
import net.shibboleth.idp.installer.plugin.impl.PluginState;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.impl.BasicKeystoreKeyStrategyTool;
import net.shibboleth.shared.security.impl.SelfSignedCertificateGenerator;
import net.shibboleth.shared.spring.context.DeferPlaceholderFileSystemXmlWebApplicationContext;
import net.shibboleth.shared.spring.context.DelimiterAwareApplicationContext;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.tools.ant.BuildException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.saml.metadata.generator.impl.MetadataGeneratorParameters;
import org.opensaml.saml.metadata.generator.impl.VelocityMetadataGenerator;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class V5Install {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(V5Install.class);
    @Nonnull
    private final InstallerPropertiesImpl installerProps;
    @Nonnull
    private final CurrentInstallState currentState;
    @Nonnull
    private final KeyManagement keyManager;
    @Nonnull
    private final HttpClient httpClient;
    @Nullable
    private final HttpClientSecurityParameters httpClientSecurityParameters;
    @Nullable
    private ModuleContext theModuleContext;

    public V5Install(@Nonnull InstallerPropertiesImpl props, @Nonnull CurrentInstallState installState, @Nonnull HttpClient client, @Nullable HttpClientSecurityParameters securityParams) {
        if (!installState.isInitialized()) {
            throw new UninitializedComponentException("Installer State not Initialized");
        }
        this.installerProps = props;
        this.currentState = installState;
        this.httpClient = client;
        this.httpClientSecurityParameters = securityParams;
        this.keyManager = new KeyManagement();
    }

    public void execute() throws BuildException {
        this.handleVersioning();
        this.checkPreConditions();
        this.enableCoreModules();
        this.keyManager.execute();
        this.populatePropertyFiles();
        this.checkWebXml(this.installerProps.getTargetDir().resolve("edit-webapp").resolve("WEB-INF").resolve("web.xml"));
        this.enableModules();
        this.deleteSpuriousFiles();
        this.generateMetadata();
        this.reprotect();
    }

    protected void checkPreConditions() throws BuildException {
        String versionAsString = Version.getVersion();
        InstallableComponentVersion idpVersion = new InstallableComponentVersion(versionAsString != null ? versionAsString : "5.0.0");
        for (IdPPlugin plugin : ServiceLoader.load(IdPPlugin.class, this.currentState.getInstalledPluginsLoader())) {
            String pluginId = plugin.getPluginId();
            InstallableComponentVersion pluginVersion = new InstallableComponentVersion((Plugin)plugin);
            try {
                this.log.debug("Considering Plugin {}, version {}", (Object)pluginId, (Object)pluginVersion);
                PluginState state = new PluginState(plugin, CollectionSupport.emptyList());
                state.setHttpClient(this.httpClient);
                state.setHttpClientSecurityParameters(this.httpClientSecurityParameters);
                state.initialize();
                if (state.getPluginInfo().isSupportedWithIdPVersion(pluginVersion, idpVersion)) continue;
                this.log.warn("Installed Plugin {} version {} is not supported with IdP Version {}, continuing.", new Object[]{pluginId, pluginVersion, idpVersion});
            }
            catch (ComponentInitializationException e) {
                this.log.error("Could not process plugin {}, continuing", (Object)plugin.getPluginId(), (Object)e);
            }
        }
    }

    protected void handleVersioning() throws BuildException {
        String installedVersion = this.currentState.getInstalledVersion();
        String currentVersion = Version.getVersion();
        if (null == currentVersion) {
            currentVersion = "5Generic";
        }
        if (null == installedVersion) {
            this.log.info("New Install.  Version: {}", (Object)currentVersion);
        } else if (currentVersion.equals(installedVersion)) {
            this.log.info("Reinstall of version {}", (Object)currentVersion);
        } else {
            this.log.info("Update from version {} to version {}", (Object)installedVersion, (Object)currentVersion);
        }
        try {
            Path versFile = this.installerProps.getTargetDir().resolve("dist").resolve("idp.installed.version");
            assert (versFile != null);
            if (Files.exists(versFile, new LinkOption[0])) {
                InstallerSupport.setReadOnly(versFile, false);
            }
            Properties vers = new Properties();
            vers.setProperty("idp.installed.version", currentVersion);
            vers.setProperty("idp.previous.installed.version", installedVersion == null ? "" : installedVersion);
            try (FileOutputStream out = new FileOutputStream(versFile.toFile());){
                vers.store(out, "Version file written at " + String.valueOf(Instant.now()));
            }
        }
        catch (IOException e) {
            this.log.error("Couldn't write version file: {}", (Object)e.getMessage());
            throw new BuildException("Couldn't write versioning information", (Throwable)e);
        }
    }

    private Properties getIdPReplacements() {
        Properties result = new Properties();
        result.setProperty("idp.entityID", this.installerProps.getEntityID());
        result.setProperty("idp.scope", this.installerProps.getScope());
        return result;
    }

    protected void populatePropertyFiles() throws BuildException {
        Path ldapMergePath;
        Closeable stream;
        File mergeFile;
        Properties replacements;
        PropertiesWithComments propertiesToReWrite;
        Set doNotReplaceList = CollectionSupport.setOf((Object[])new String[]{"idp.sealer.storePassword", "idp.sealer.keyPassword", "idp.authn.LDAP.bindDNCredential", "idp.attribute.resolver.LDAP.bindDNCredential", "idp.persistentId.salt"});
        Path conf = this.installerProps.getTargetDir().resolve("conf");
        if (!this.currentState.isIdPPropertiesPresent()) {
            try {
                Path target = conf.resolve("idp.properties");
                if (!Files.exists(target, new LinkOption[0])) {
                    throw new BuildException("idp.properties didnt exist.  Was irp.Core installed");
                }
                Path mergePath = this.installerProps.getIdPMergeProperties();
                propertiesToReWrite = new PropertiesWithComments(doNotReplaceList);
                if (mergePath != null) {
                    this.log.debug("Updating {} from ", (Object)target, (Object)mergePath);
                    replacements = new Properties();
                    mergeFile = mergePath.toFile();
                    if (!this.installerProps.isNoTidy()) {
                        mergeFile.deleteOnExit();
                        this.log.debug("Marked {} for delete on close", (Object)mergeFile.getAbsolutePath());
                    }
                    stream = new FileInputStream(mergeFile);
                    try {
                        replacements.load((InputStream)stream);
                    }
                    finally {
                        ((FileInputStream)stream).close();
                    }
                } else {
                    replacements = this.getIdPReplacements();
                    this.log.debug("Updating {} from {}", (Object)target, replacements.keySet());
                }
                try (Closeable stream2 = new FileInputStream(target.toFile());){
                    propertiesToReWrite.load((InputStream)stream2);
                }
                propertiesToReWrite.replaceProperties(replacements);
                stream2 = new FileOutputStream(target.toFile());
                try {
                    propertiesToReWrite.store((OutputStream)stream2);
                }
                finally {
                    ((FileOutputStream)stream2).close();
                }
            }
            catch (IOException e) {
                throw new BuildException("Failed to regenerate idp.properties", (Throwable)e);
            }
        }
        if ((ldapMergePath = this.installerProps.getLDAPMergeProperties()) != null && !this.currentState.isLDAPPropertiesPresent()) {
            this.log.debug("Merging {} with ldap.properties", (Object)ldapMergePath);
            try {
                Path target = conf.resolve("ldap.properties");
                if (!Files.exists(target, new LinkOption[0])) {
                    throw new BuildException("Internal error - ldap.properties doesnt exist ?");
                }
                this.log.debug("Updating {} from {}", (Object)target, (Object)ldapMergePath);
                propertiesToReWrite = new PropertiesWithComments(doNotReplaceList);
                replacements = new Properties();
                mergeFile = ldapMergePath.toFile();
                if (!this.installerProps.isNoTidy()) {
                    mergeFile.deleteOnExit();
                }
                stream = new FileInputStream(mergeFile);
                try {
                    replacements.load((InputStream)stream);
                }
                finally {
                    ((FileInputStream)stream).close();
                }
                stream = new FileInputStream(target.toFile());
                try {
                    propertiesToReWrite.load((InputStream)stream);
                }
                finally {
                    ((FileInputStream)stream).close();
                }
                propertiesToReWrite.replaceProperties(replacements);
                stream = new FileOutputStream(target.toFile());
                try {
                    propertiesToReWrite.store((OutputStream)stream);
                }
                finally {
                    ((FileOutputStream)stream).close();
                }
            }
            catch (IOException e) {
                throw new BuildException("Failed to regenerate ldap.properties", (Throwable)e);
            }
        }
        if (null == this.currentState.getInstalledVersion()) {
            this.log.debug("Detected a new Install.  Creating secrets.properties.");
            Path secrets = this.installerProps.getTargetDir().resolve("credentials").resolve("secrets.properties");
            try (FileWriter fileWriter = new FileWriter(secrets.toFile());
                 BufferedWriter out = new BufferedWriter(fileWriter);){
                String ldapPassword;
                out.write("# This is a reserved spot for most properties containing passwords or other secrets.");
                out.newLine();
                out.write("# Created by install at " + String.valueOf(Instant.now()));
                out.newLine();
                out.newLine();
                out.write("# Access to internal AES encryption key");
                out.newLine();
                String password = this.keyManager.isCreatedSealer() ? this.installerProps.getSealerPassword() : "password";
                out.write("idp.sealer.storePassword =" + password);
                out.newLine();
                out.write("idp.sealer.keyPassword =" + password);
                out.newLine();
                out.newLine();
                if (this.keyManager.isCreatedBackchannel()) {
                    out.write("# Password for idp-backchannel.p12 ");
                    out.newLine();
                    out.write("idp.backchannel.keyStorePassword =" + this.installerProps.getKeyStorePassword());
                    out.newLine();
                    out.newLine();
                }
                if (null == (ldapPassword = this.installerProps.getLDAPPassword())) {
                    ldapPassword = "myServicePassword";
                }
                out.write("# Default access to LDAP authn and attribute stores. ");
                out.newLine();
                out.write("idp.authn.LDAP.bindDNCredential              =" + ldapPassword);
                out.newLine();
                out.write("idp.attribute.resolver.LDAP.bindDNCredential =%{idp.authn.LDAP.bindDNCredential:undefined}");
                out.newLine();
                out.newLine();
                out.write("# Salt used to generate persistent/pairwise IDs, must be kept secret");
                out.newLine();
                out.write("#idp.persistentId.salt =changethistosomethingrandom");
                out.newLine();
            }
            catch (IOException e) {
                throw new BuildException("Failed to generate secrets.properties", (Throwable)e);
            }
        }
    }

    private void checkWebXml(Path webXml) throws BuildException {
        if (Files.notExists(webXml, new LinkOption[0])) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(webXml.toFile()));){
            Pattern pat = Pattern.compile(".*net\\.shibboleth\\.ext\\.spring\\.context\\.DeferPlaceholderFileSystemXmlWebApplicationContext.*");
            Pattern systemInWebXml = Pattern.compile(".*\\$\\{idp\\.home\\}/system.*");
            boolean foundPat1 = false;
            boolean foundSystemInWebXml = false;
            String line = in.readLine();
            while (line != null) {
                if (!foundPat1 && pat.matcher(line).matches()) {
                    foundPat1 = true;
                    this.log.warn("Your copy of edit-webapp/WEB-INF/web.xml contains a reference to a replaced class, {}", (Object)DeferPlaceholderFileSystemXmlWebApplicationContext.class.getCanonicalName());
                    this.log.warn("You MUST update this to {} and rebuild the war after installation or the IdP will refuse to start", (Object)DelimiterAwareApplicationContext.class.getCanonicalName());
                }
                if (!foundSystemInWebXml && systemInWebXml.matcher(line).matches()) {
                    foundSystemInWebXml = true;
                    this.log.warn("Your copy of edit-webapp/WEB-INF/web.xml contains a reference to ${idp.home}/system");
                    this.log.warn("This no longer exists. Make the required changed and rebuild the war after installation or the IdP will refuse to start");
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    @Nonnull
    private ModuleContext ensureModuleContext() {
        ModuleContext context = this.theModuleContext;
        if (context == null) {
            String targetDir = this.installerProps.getTargetDir().toString();
            assert (targetDir != null);
            context = new ModuleContext(targetDir);
            context.setHttpClient(this.httpClient);
            context.setHttpClientSecurityParameters(this.httpClientSecurityParameters);
            if (this.currentState.getInstalledVersion() == null) {
                context.setOperationType(ModuleContext.OperationType.Install);
            } else {
                context.setOperationType(ModuleContext.OperationType.Upgrade);
            }
            this.theModuleContext = context;
        }
        return context;
    }

    protected void enableCoreModules() throws BuildException {
        ModuleContext moduleContext = this.ensureModuleContext();
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class).iterator();
        while (modules.hasNext()) {
            try {
                IdPModule module = modules.next();
                String id = module.getId();
                if (!this.installerProps.getCoreModules().contains(id) || this.currentState.getEnabledModules().contains(id)) continue;
                try {
                    module.enable(moduleContext, false);
                }
                catch (ModuleException e) {
                    this.log.error("Error performing initial enable on module {}", (Object)id, (Object)e);
                    throw new BuildException((Throwable)e);
                }
            }
            catch (ServiceConfigurationError e) {
                this.log.error("Error loading modules", (Throwable)e);
            }
        }
    }

    protected void enableModules() throws BuildException {
        ModuleContext moduleContext = this.ensureModuleContext();
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class).iterator();
        while (modules.hasNext()) {
            try {
                IdPModule module = modules.next();
                String id = module.getId();
                if (this.currentState.getEnabledModules().contains(id)) {
                    this.log.debug("Re-enabling Module {}", (Object)id);
                    try {
                        module.enable(moduleContext, true);
                    }
                    catch (ModuleException e) {
                        this.log.error("Error re-enabling module {}", (Object)id, (Object)e);
                        throw new BuildException((Throwable)e);
                    }
                }
                if (this.currentState.getInstalledVersion() != null || !this.installerProps.getModulesToEnable().contains(id)) continue;
                try {
                    module.enable(moduleContext, false);
                }
                catch (ModuleException e) {
                    this.log.error("Error performing initial enable on module {}", (Object)id, (Object)e);
                    throw new BuildException((Throwable)e);
                }
            }
            catch (ServiceConfigurationError e) {
                this.log.error("Error loading modules", (Throwable)e);
            }
        }
    }

    protected void deleteSpuriousFiles() throws BuildException {
        for (Path p : this.currentState.getPathsToBeDeleted()) {
            if (!Files.exists(p, new LinkOption[0])) {
                this.log.trace("File to be deleted {} was not created", (Object)p.getFileName());
                continue;
            }
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                this.log.debug("Delete failed", (Throwable)e);
            }
        }
    }

    protected void generateMetadata() throws BuildException {
        if (this.currentState.getInstalledVersion() != null) {
            this.log.debug("Skipping Metadata generation on update from version {}", (Object)this.currentState.getInstalledVersion());
            return;
        }
        Path parentDir = this.installerProps.getTargetDir().resolve("metadata");
        File metadataFile = parentDir.resolve("idp-metadata.xml").toFile();
        assert (metadataFile != null);
        if (metadataFile.exists()) {
            this.log.debug("Metadata file {} exists", (Object)metadataFile.toString());
            return;
        }
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            this.log.error("Could not intiailize opensaml", (Throwable)e);
            throw new BuildException((Throwable)e);
        }
        ClassPathResource resource = new ClassPathResource("net/shibboleth/idp/installer/metadata-generator.xml");
        GenericApplicationContext context = new ApplicationContextBuilder().setName(V5Install.class.getName()).setServiceConfigurations((Collection)CollectionSupport.singletonList((Object)resource)).setContextInitializer((ApplicationContextInitializer)new Initializer()).build();
        this.log.info("Creating Metadata to {}", (Object)metadataFile);
        InstalledMetadataParameters parameters = (InstalledMetadataParameters)((Object)context.getBean("IdPConfiguration", InstalledMetadataParameters.class));
        parameters.setDnsName(this.installerProps.getHostName());
        VelocityEngine engine = (VelocityEngine)context.getBean("VelocityEngine", VelocityEngine.class);
        this.log.debug("Parameters {}", (Object)parameters);
        try (FileWriter sink = new FileWriter(metadataFile);){
            sink.write("<!--\n This is example metadata only. Do *NOT* supply it as is without review,\nand do *NOT* provide it in real time to your partners.\nThis metadata is not dynamic - it will not change as your configuration changes.\nOn Demand Metadata Generation available from the metadatagen plugin.\n-->\n");
            VelocityMetadataGenerator generator = new VelocityMetadataGenerator();
            generator.setId("Installer Metadata Generator");
            generator.setVelocityEngine(engine);
            generator.initialize();
            generator.generate((MetadataGeneratorParameters)parameters, (Writer)sink);
        }
        catch (ComponentInitializationException e) {
            this.log.error("Metadata Generator initialization failed", (Throwable)e);
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Metadata Generator failed to write to", (Object)metadataFile, (Object)e);
            throw new BuildException((Throwable)e);
        }
    }

    protected void reprotect() throws BuildException {
        Path dist = this.installerProps.getTargetDir().resolve("dist");
        Path pluginContents = dist.resolve("plugin-contents");
        Path pluginWebapp = dist.resolve("plugin-webapp");
        assert (pluginContents != null && pluginWebapp != null && dist != null);
        InstallerSupport.setReadOnly(dist, true);
        InstallerSupport.setReadOnly(pluginContents, false);
        InstallerSupport.setReadOnly(pluginWebapp, false);
        if (this.installerProps.isSetGroupAndMode()) {
            Path bin = this.installerProps.getTargetDir().resolve("bin");
            Path credentials = this.installerProps.getTargetDir().resolve("credentials");
            assert (bin != null && credentials != null);
            InstallerSupport.setMode(bin, "755", "**/*.sh");
            InstallerSupport.setMode(dist, "444", "**/*");
            InstallerSupport.setMode(pluginContents, "640", "**/*");
            InstallerSupport.setMode(pluginWebapp, "640", "**/*");
            if (this.currentState.getInstalledVersion() == null) {
                InstallerSupport.setMode(credentials, this.installerProps.getCredentialsKeyFileMode(), "**/*");
                String group = this.installerProps.getCredentialsGroup();
                if (group != null) {
                    InstallerSupport.setGroup(credentials, group, "**/*");
                }
            }
        }
    }

    private class KeyManagement {
        private boolean createdSigning;
        private boolean createdEncryption;
        private boolean createdBackchannel;
        private boolean createdSealer;

        private KeyManagement() {
        }

        protected void execute() throws BuildException {
            if (V5Install.this.currentState.getInstalledVersion() != null) {
                V5Install.this.log.debug("Skipping key generation");
                return;
            }
            this.createdSigning = this.generateKey("idp-signing");
            this.createdEncryption = this.generateKey("idp-encryption");
            this.generateKeyStore();
            this.generateSealer();
        }

        private boolean generateKey(String fileBase) throws BuildException {
            Path credentials = V5Install.this.installerProps.getTargetDir().resolve("credentials");
            Path key = credentials.resolve(fileBase + ".key");
            Path crt = credentials.resolve(fileBase + ".crt");
            if (Files.exists(key, new LinkOption[0]) && Files.exists(crt, new LinkOption[0])) {
                if (!V5Install.this.currentState.isIdPPropertiesPresent()) {
                    V5Install.this.log.error("key files {} and {} exist but idp.properties does not", (Object)key, (Object)crt);
                    throw new BuildException("Invalid key file configuration");
                }
                V5Install.this.log.debug("keys files {} and {} exist.  Not generating", (Object)key, (Object)crt);
                return false;
            }
            if (V5Install.this.currentState.isIdPPropertiesPresent()) {
                V5Install.this.log.error("idp.properties exists but key files {} and/or {} do not", (Object)key, (Object)crt);
                throw new BuildException("Invalid key file configuration");
            }
            if (Files.exists(key, new LinkOption[0]) || Files.exists(crt, new LinkOption[0])) {
                V5Install.this.log.error("One of two expected key files {} and {} exist", (Object)key, (Object)crt);
                throw new BuildException("Invalid key file configuration");
            }
            SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();
            generator.setCertificateFile(crt.toFile());
            generator.setPrivateKeyFile(key.toFile());
            generator.setKeySize(V5Install.this.installerProps.getKeySize());
            generator.setHostName(V5Install.this.installerProps.getHostName());
            generator.setURISubjectAltNames((Collection)CollectionSupport.singletonList((Object)V5Install.this.installerProps.getSubjectAltName()));
            V5Install.this.log.info("Creating {}, CN = {} URI = {}, keySize={}", new Object[]{fileBase, V5Install.this.installerProps.getHostName(), V5Install.this.installerProps.getSubjectAltName(), V5Install.this.installerProps.getKeySize()});
            try {
                generator.generate();
            }
            catch (Exception e) {
                V5Install.this.log.error("Error building {} files", (Object)fileBase, (Object)e);
                throw new BuildException("Error Building Self Signed Cert", (Throwable)e);
            }
            V5Install.this.log.debug("... Done");
            return true;
        }

        private void generateKeyStore() {
            Path credentials = V5Install.this.installerProps.getTargetDir().resolve("credentials");
            Path keyStore = credentials.resolve("idp-backchannel.p12");
            Path crt = credentials.resolve("idp-backchannel.crt");
            if (Files.exists(keyStore, new LinkOption[0]) && Files.exists(crt, new LinkOption[0])) {
                if (!V5Install.this.currentState.isIdPPropertiesPresent()) {
                    V5Install.this.log.error("Key store files {} and {} exist but idp.properties does not", (Object)keyStore, (Object)crt);
                    throw new BuildException("Invalid key file configuration");
                }
                V5Install.this.log.debug("Keys store files {} and {} exist.  Not generating", (Object)keyStore, (Object)crt);
            } else {
                if (V5Install.this.currentState.isIdPPropertiesPresent()) {
                    V5Install.this.log.error("idp.properties exists but key store files {} and/or {} do not", (Object)keyStore, (Object)crt);
                    throw new BuildException("Invalid key file configuration");
                }
                if (Files.exists(keyStore, new LinkOption[0]) || Files.exists(crt, new LinkOption[0])) {
                    V5Install.this.log.error("One of two expected key files {} and {} exist", (Object)keyStore, (Object)crt);
                    throw new BuildException("Invalid key file configuration");
                }
                SelfSignedCertificateGenerator generator = new SelfSignedCertificateGenerator();
                generator.setCertificateFile(crt.toFile());
                generator.setKeystoreFile(keyStore.toFile());
                generator.setKeySize(V5Install.this.installerProps.getKeySize());
                generator.setHostName(V5Install.this.installerProps.getHostName());
                generator.setURISubjectAltNames((Collection)CollectionSupport.singletonList((Object)V5Install.this.installerProps.getSubjectAltName()));
                generator.setKeystorePassword(V5Install.this.installerProps.getKeyStorePassword());
                V5Install.this.log.info("Creating backchannel keystore, CN = {} URI = {}, keySize={}", new Object[]{V5Install.this.installerProps.getHostName(), V5Install.this.installerProps.getSubjectAltName(), V5Install.this.installerProps.getKeySize()});
                try {
                    generator.generate();
                }
                catch (Exception e) {
                    V5Install.this.log.error("Error building backchannel ketsyore files", (Throwable)e);
                    throw new BuildException("Error Building Backchannel Key Store", (Throwable)e);
                }
                this.createdBackchannel = true;
            }
        }

        private void generateSealer() {
            Path credentials = V5Install.this.installerProps.getTargetDir().resolve("credentials");
            File sealerFile = credentials.resolve("sealer.jks").toFile();
            File versionFile = credentials.resolve("sealer.kver").toFile();
            assert (sealerFile != null && versionFile != null);
            if (sealerFile.exists() && versionFile.exists()) {
                if (!V5Install.this.currentState.isIdPPropertiesPresent()) {
                    V5Install.this.log.error("Cookie encryption files {} and {} exist, but idp.properties does not", (Object)sealerFile, (Object)versionFile);
                    throw new BuildException("Invalid Cookie encryption  file configuration");
                }
                V5Install.this.log.debug("Cookie encryption files {} and {} exists.  Not generating.", (Object)sealerFile, (Object)versionFile);
            } else {
                if (V5Install.this.currentState.isIdPPropertiesPresent()) {
                    V5Install.this.log.error("idp.properties exists but cookie encryption files {} do not", (Object)sealerFile, (Object)versionFile);
                    throw new BuildException("Invalid key file configuration");
                }
                if (sealerFile.exists() || versionFile.exists()) {
                    V5Install.this.log.error("One of two expected cookie encryption file {} and {} exist", (Object)sealerFile, (Object)versionFile);
                    throw new BuildException("Invalid cookie encryption file configuration");
                }
                BasicKeystoreKeyStrategyTool generator = new BasicKeystoreKeyStrategyTool();
                generator.setKeystoreFile(sealerFile);
                generator.setVersionFile(versionFile);
                Integer keySize = V5Install.this.installerProps.getSealerKeySize();
                if (keySize != null) {
                    generator.setKeySize(keySize.intValue());
                }
                generator.setKeyAlias(V5Install.this.installerProps.getSealerAlias());
                generator.setKeystorePassword(V5Install.this.installerProps.getSealerPassword());
                V5Install.this.log.info("Creating Sealer KeyStore");
                try {
                    generator.changeKey();
                }
                catch (Exception e) {
                    V5Install.this.log.error("Error building cookie encryption files", (Throwable)e);
                    throw new BuildException("Error Building Cookie Encryption", (Throwable)e);
                }
                this.createdSealer = true;
            }
        }

        public boolean isCreatedSigning() {
            return this.createdSigning;
        }

        public boolean isCreatedEncryption() {
            return this.createdEncryption;
        }

        public boolean isCreatedBackchannel() {
            return this.createdBackchannel;
        }

        public boolean isCreatedSealer() {
            return this.createdSealer;
        }
    }

    private class Initializer
    extends IdPPropertiesApplicationContextInitializer {
        private Initializer() {
        }

        @Nonnull
        public String selectSearchLocation(@Nonnull ConfigurableApplicationContext applicationContext) {
            String result = V5Install.this.installerProps.getTargetDir().toString();
            assert (result != null);
            return result;
        }

        @Nonnull
        public String getSearchLocation() {
            String result = V5Install.this.installerProps.getTargetDir().toString();
            assert (result != null);
            return result;
        }

        public void initialize(@Nonnull ConfigurableApplicationContext applicationContext) {
            Properties props = new Properties(2);
            props.setProperty("idp.backchannel.cert", V5Install.this.installerProps.getTargetDir().resolve("credentials").resolve("idp-backchannel.crt").toString());
            props.setProperty("idp.dnsname", V5Install.this.installerProps.getHostName());
            this.appendPropertySource(applicationContext, "internal", props);
            super.initialize(applicationContext);
        }
    }
}

