/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.slf4j.Logger;

public class InstallerPropertiesImpl {
    @Nonnull
    @NotEmpty
    public static final String INITIAL_INSTALL_MODULES = "idp.initial.modules";
    @Nonnull
    public static final Set<String> CORE_MODULES = CollectionSupport.setOf((Object[])new String[]{"idp.Core", "idp.EditWebApp", "idp.CommandLine"});
    @Nonnull
    public static final Set<String> DEFAULT_MODULES = CollectionSupport.setOf((Object)"idp.authn.Password", (Object)"idp.admin.Hello");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InstallerPropertiesImpl.class);
    @NonnullAfterInit
    private Properties installerProperties;
    @Nullable
    private Path targetDir;
    @Nonnull
    private final Path srcDir;
    private boolean noPrompt;
    @Nullable
    private String entityID;
    @Nullable
    private String hostname;
    @Nullable
    private String scope;
    @Nullable
    private String keyStorePassword;
    @Nullable
    private String sealerPassword;
    @Nullable
    private String sealerAlias;
    private int keySize;
    private boolean tidy = true;
    private boolean setGroupAndMode = true;
    @Nullable
    private String credentialsKeyFileMode;
    @Nonnull
    private final InputHandler inputHandler;

    public InstallerPropertiesImpl(@Nonnull Path sourceDir) {
        this.srcDir = sourceDir;
        this.inputHandler = this.getInputHandler();
    }

    @Nonnull
    protected InputHandler getInputHandler() {
        return new DefaultInputHandler(){

            protected String getPrompt(InputRequest request) {
                return super.getPrompt(request) + " ? ";
            }
        };
    }

    private void setNoTidy() {
        String noTidy = this.installerProperties.getProperty("idp.no.tidy");
        this.tidy = noTidy == null;
    }

    protected void doInitialize() throws ComponentInitializationException {
        String value;
        this.installerProperties = new Properties(System.getProperties());
        if (!Files.exists(this.srcDir, new LinkOption[0])) {
            this.log.error("Source dir {} did not exist", (Object)this.srcDir.toAbsolutePath());
            throw new ComponentInitializationException(this.srcDir.toString() + " must exist");
        }
        this.log.debug("Source dir {}", (Object)this.srcDir);
        Path propertyFile = this.getMergeFile("idp.property.file");
        if (propertyFile != null) {
            File idpPropertyFile = propertyFile.toFile();
            try (FileInputStream stream = new FileInputStream(idpPropertyFile);){
                this.installerProperties.load(stream);
            }
            catch (IOException e) {
                this.log.error("Could not load {}: {}", (Object)propertyFile.toAbsolutePath(), (Object)e.getMessage());
                throw new ComponentInitializationException((Exception)e);
            }
            this.setNoTidy();
            if (!this.isNoTidy()) {
                idpPropertyFile.deleteOnExit();
                this.log.debug("Marked {} for delete on close", (Object)idpPropertyFile.getAbsolutePath());
            }
        } else {
            this.setNoTidy();
        }
        String setModeString = this.installerProperties.getProperty("idp.conf.setmode");
        if (setModeString != null) {
            this.setGroupAndMode = Boolean.valueOf(setModeString);
        }
        this.noPrompt = (value = this.installerProperties.getProperty("idp.noprompt")) != null;
        value = this.installerProperties.getProperty("idp.keysize");
        this.keySize = value == null ? 3072 : Integer.parseInt(value);
    }

    private static boolean hasHostName(InetAddress addr) {
        return !addr.getHostAddress().equals(addr.getCanonicalHostName());
    }

    @Nonnull
    private static String getBestHostName() {
        InetAddress bestSoFar = null;
        try {
            for (NetworkInterface netInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress address : Collections.list(netInterface.getInetAddresses())) {
                    if (bestSoFar == null) {
                        bestSoFar = address;
                        continue;
                    }
                    if (address == null || address.isLoopbackAddress()) continue;
                    if (address.isLinkLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress()) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (address.isSiteLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && (!bestSoFar.isSiteLocalAddress() || InstallerPropertiesImpl.hasHostName(bestSoFar))) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && !bestSoFar.isSiteLocalAddress() && InstallerPropertiesImpl.hasHostName(bestSoFar)) continue;
                    bestSoFar = address;
                }
            }
        }
        catch (SocketException e) {
            LoggerFactory.getLogger(InstallerSupport.class).error("Could not get host information", (Throwable)e);
        }
        if (bestSoFar == null) {
            return "localhost.localdomain";
        }
        String result = bestSoFar.getCanonicalHostName();
        assert (result != null);
        return result;
    }

    @Nonnull
    protected String getValue(String propertyName, String prompt, NonnullSupplier<String> defaultSupplier) throws BuildException {
        String value = this.installerProperties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        if (this.noPrompt) {
            throw new BuildException("No value for " + propertyName + " specified");
        }
        InputRequest request = new InputRequest(prompt);
        String defaultValue = (String)defaultSupplier.get();
        request.setDefaultValue(defaultValue);
        this.inputHandler.handleInput(request);
        value = request.getInput();
        if (value == null || "".contentEquals(value)) {
            return defaultValue;
        }
        return value;
    }

    @Nonnull
    protected String getPassword(String propertyName, String prompt) throws BuildException {
        String value = this.installerProperties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        try {
            byte[] key = new byte[32];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(key);
            String s = Base64Support.encode((byte[])key, (boolean)false).substring(0, 32);
            assert (s != null);
            return s;
        }
        catch (NoSuchAlgorithmException | EncodingException e) {
            this.log.error("Password Generation failed", e);
            throw new BuildException("Password Generation failed", e);
        }
    }

    @Nonnull
    public Path getTargetDir() throws BuildException {
        if (this.targetDir != null) {
            return this.targetDir;
        }
        Path td = this.targetDir = InstallerSupport.pathOf(this.getValue("idp.target.dir", "Installation Directory:", (NonnullSupplier<String>)((NonnullSupplier)() -> "/opt/shibboleth-idp")));
        assert (td != null);
        return td;
    }

    @Nonnull
    public Path getSourceDir() {
        return this.srcDir;
    }

    @Nonnull
    public String getEntityID() {
        String result = this.entityID;
        if (result == null) {
            this.entityID = result = this.getValue("idp.entityID", "SAML EntityID:", (NonnullSupplier<String>)((NonnullSupplier)() -> "https://" + this.getHostName() + "/idp/shibboleth"));
        }
        return result;
    }

    public boolean isNoTidy() {
        return !this.tidy;
    }

    @Nonnull
    public String getHostName() {
        String result = this.hostname;
        if (result == null) {
            result = this.hostname = this.getValue("idp.host.name", "Host Name:", (NonnullSupplier<String>)((NonnullSupplier)() -> InstallerPropertiesImpl.getBestHostName()));
        }
        return result;
    }

    @Nonnull
    public String getCredentialsKeyFileMode() {
        String result = this.credentialsKeyFileMode;
        if (result != null) {
            return result;
        }
        result = this.credentialsKeyFileMode = this.installerProperties.getProperty("idp.conf.credentials.filemode", "600");
        assert (result != null);
        return result;
    }

    @Nullable
    public String getCredentialsGroup() {
        return this.installerProperties.getProperty("idp.conf.credentials.group");
    }

    public boolean isSetGroupAndMode() {
        return this.setGroupAndMode;
    }

    @Nonnull
    protected String defaultScope() {
        String host = this.getHostName();
        int index = host.indexOf(46);
        if (index > 1) {
            String result = host.substring(index + 1);
            assert (result != null);
            return result;
        }
        return "localdomain";
    }

    @Nonnull
    public String getScope() {
        String result = this.scope;
        if (result == null) {
            result = this.scope = this.getValue("idp.scope", "Attribute Scope:", (NonnullSupplier<String>)((NonnullSupplier)() -> this.defaultScope()));
        }
        return result;
    }

    @Nullable
    public String getLDAPPassword() throws BuildException {
        return this.installerProperties.getProperty("idp.LDAP.credential");
    }

    @Nonnull
    public String getSubjectAltName() {
        return "https://" + this.getHostName() + "/idp/shibboleth";
    }

    @Nonnull
    public String getKeyStorePassword() {
        String result = this.keyStorePassword;
        if (this.keyStorePassword == null) {
            result = this.keyStorePassword = this.getPassword("idp.keystore.password", "Backchannel PKCS12 Password:");
        }
        assert (result != null);
        return result;
    }

    @Nonnull
    public String getSealerPassword() {
        String result = this.sealerPassword;
        if (result == null) {
            result = this.sealerPassword = this.getPassword("idp.sealer.password", "Cookie Encryption Key Password:");
        }
        return result;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getModulesToEnable() {
        String prop = StringSupport.trimOrNull((String)this.installerProperties.getProperty(INITIAL_INSTALL_MODULES));
        if (prop == null) {
            return DEFAULT_MODULES;
        }
        boolean additive = prop.startsWith("+");
        if (additive) {
            prop = prop.substring(1);
        }
        Object[] modules = prop.split(",");
        assert (modules != null);
        if (!additive) {
            Set result = CollectionSupport.copyToSet((Collection)CollectionSupport.arrayAsList((Object[])modules));
            return result;
        }
        HashSet<Object> result = new HashSet<Object>(modules.length + DEFAULT_MODULES.size());
        result.addAll(DEFAULT_MODULES);
        result.addAll(Arrays.asList(modules));
        return CollectionSupport.copyToSet(result);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getCoreModules() {
        return CORE_MODULES;
    }

    @Nullable
    Integer getSealerKeySize() throws BuildException {
        Integer result;
        String val = this.installerProperties.getProperty("idp.sealer.keysize");
        if (val == null) {
            return null;
        }
        try {
            result = Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            this.log.error("Provided value for property {} ({}') was not an integer", (Object)"idp.sealer.alias", (Object)val);
            throw new BuildException((Throwable)e);
        }
        return result;
    }

    @Nonnull
    public String getSealerAlias() {
        String result = this.sealerAlias;
        if (result == null) {
            result = this.sealerAlias = this.installerProperties.getProperty("idp.sealer.alias");
        }
        if (result == null) {
            this.sealerAlias = "secret";
            result = "secret";
        }
        return result;
    }

    public int getKeySize() {
        return this.keySize;
    }

    @Nullable
    protected Path getMergeFile(String propName) throws BuildException {
        String propValue = this.installerProperties.getProperty(propName);
        if (propValue == null) {
            return null;
        }
        Path path = InstallerSupport.pathOf(propValue);
        if (Files.exists(path, new LinkOption[0])) {
            this.log.debug("Property '{}' had value '{}' Path exists ", (Object)propName, (Object)propValue);
        } else {
            if (!Files.exists(path = this.srcDir.resolve(path), new LinkOption[0])) {
                this.log.debug("Property '{}' had value '{}' neither '{}' nor '{}' exist", new Object[]{propName, propValue, path});
                this.log.error("Path '{}' supplied for '{}' does not exist", (Object)propValue, (Object)propName);
                throw new BuildException("Property file not found");
            }
            this.log.debug("Property '{}' had value '{}' Path {} exists ", new Object[]{propName, propValue, path});
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.log.error("Path '{}' supplied by property '{}' was not a file", (Object)path, (Object)propName);
            throw new BuildException("No a file");
        }
        return path;
    }

    @Nullable
    public Path getIdPMergeProperties() throws BuildException {
        return this.getMergeFile("idp.merge.properties");
    }

    @Nullable
    public Path getLDAPMergeProperties() throws BuildException {
        return this.getMergeFile("ldap.merge.properties");
    }
}

