/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.PropertiesWithComments;

@Deprecated
public final class FinalizeJettyBase {
    @Nonnull
    private final Path idpHome;
    @Nonnull
    private final Path jettyBase;

    private FinalizeJettyBase() throws IOException {
        String home = System.getProperty("idp.home");
        if (home == null) {
            System.err.println("idp.home not specified");
            throw new IOException("idp.home not specified");
        }
        Path p = InstallerSupport.pathOf(home);
        assert (p != null);
        this.idpHome = p;
        if (!Files.exists(this.idpHome, new LinkOption[0]) || !Files.isDirectory(this.idpHome, new LinkOption[0])) {
            String msg = "'" + home + "' does not exist or is not a directory";
            System.err.println(msg);
            throw new IOException(msg);
        }
        p = this.idpHome.resolve("jetty-base");
        assert (p != null);
        this.jettyBase = p;
        if (!Files.exists(this.jettyBase, new LinkOption[0]) || !Files.isDirectory(this.jettyBase, new LinkOption[0])) {
            String msg = "'" + home + "/jetty-base' does not exist or is not a directory";
            System.err.println(msg);
            throw new IOException(msg);
        }
        p = this.jettyBase.resolve("start.d.dist");
        if (!Files.exists(p, new LinkOption[0]) || !Files.isDirectory(p, new LinkOption[0])) {
            String msg = "'" + home + "/jetty-base/start.d.dist' does not exist or is not a directory";
            System.err.println(msg);
            throw new IOException(msg);
        }
    }

    private void execute() throws IOException {
        this.createDirectories();
        Path idpIni = this.jettyBase.resolve("start.d").resolve("idp.ini");
        if (Files.exists(idpIni, new LinkOption[0])) {
            this.updateIdPini();
        } else {
            this.createP12IdPini();
        }
        Path systemIniSrc = this.jettyBase.resolve("start.d.dist").resolve("idp-system.ini");
        Path dest = this.jettyBase.resolve("start.d").resolve("idp-system.ini");
        assert (systemIniSrc != null && dest != null);
        this.copyFile(systemIniSrc, dest);
        this.reprotect();
    }

    private void createDirectories() throws IOException {
        Files.createDirectories(this.jettyBase.resolve("start.d"), new FileAttribute[0]);
        Files.createDirectories(this.jettyBase.resolve("logs"), new FileAttribute[0]);
        Files.createDirectories(this.idpHome.resolve("static"), new FileAttribute[0]);
    }

    private void createP12IdPini() throws IOException {
        Path credentials = this.idpHome.resolve("credentials");
        Path backChannelKeyStore = credentials.resolve("idp-backchannel.p12");
        Path sslKeyStore = credentials.resolve("idp-userfacing.p12");
        assert (backChannelKeyStore != null && sslKeyStore != null);
        if (!Files.exists(backChannelKeyStore, new LinkOption[0])) {
            String msg = backChannelKeyStore.toString() + " Does not exist";
            System.err.println(msg);
            throw new IOException(msg);
        }
        if (Files.exists(sslKeyStore, new LinkOption[0])) {
            String msg = sslKeyStore.toString() + " Exists";
            System.err.println(msg);
            throw new IOException(msg);
        }
        this.copyFile(backChannelKeyStore, sslKeyStore);
        Properties passwords = new Properties();
        try (FileInputStream in = new FileInputStream(credentials.resolve("secrets.properties").toFile());){
            passwords.load(in);
        }
        String p12Pass = passwords.getProperty("idp.backchannel.keyStorePassword");
        Properties replace = new Properties(2);
        replace.setProperty("idp.backchannel.keyStorePassword", p12Pass);
        replace.setProperty("jetty.sslContext.keyStorePassword", p12Pass);
        PropertiesWithComments idpIni = new PropertiesWithComments();
        File inputIni = this.jettyBase.resolve("start.d.dist").resolve("idp.ini.windows").toFile();
        File outputIni = this.jettyBase.resolve("start.d").resolve("idp.ini").toFile();
        try (FileInputStream in = new FileInputStream(inputIni);
             FileOutputStream out = new FileOutputStream(outputIni);){
            idpIni.load(in);
            idpIni.replaceProperties(replace);
            idpIni.store(out);
        }
    }

    private void updateIdPini() throws IOException {
        PropertiesWithComments props = new PropertiesWithComments();
        File idpIni = this.jettyBase.resolve("start.d").resolve("idp.ini").toFile();
        File replacementFile = this.jettyBase.resolve("start.d.dist").resolve("idp.ini.rewrite.property.names").toFile();
        try (FileInputStream in = new FileInputStream(idpIni);
             FileInputStream replacementStream = new FileInputStream(replacementFile);){
            props.loadNameReplacement(replacementStream);
            props.load(in);
        }
        try (FileOutputStream out = new FileOutputStream(idpIni);){
            props.store(out);
        }
    }

    private void copyFile(@Nonnull Path fromFile, @Nonnull Path toFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(toFile.toFile());){
            Files.copy(fromFile, out);
        }
    }

    private void reprotect() {
        Path libDir = this.jettyBase.resolve("lib");
        assert (libDir != null);
        InstallerSupport.setReadOnlyDir(libDir, false);
        InstallerSupport.setMode(libDir, "444", "*");
        Path etcDir = this.jettyBase.resolve("etc");
        assert (etcDir != null);
        InstallerSupport.setReadOnlyDir(etcDir, false);
        InstallerSupport.setMode(etcDir, "444", "*");
        Path webapps = this.jettyBase.resolve("webapps");
        assert (webapps != null);
        InstallerSupport.setReadOnlyDir(webapps, false);
        InstallerSupport.setMode(webapps, "444", "*");
    }

    public static void main(String[] args) throws IOException {
        new FinalizeJettyBase().execute();
    }
}

