/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.installer.ProgressReportingOutputStream;
import net.shibboleth.idp.installer.plugin.impl.LoggingVisitor;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.taskdefs.optional.unix.Chgrp;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.slf4j.Logger;

public final class InstallerSupport {
    @Nonnull
    @NotEmpty
    public static final String VERSION_NAME = "idp.installed.version";
    @Nonnull
    @NotEmpty
    public static final String PREVIOUS_VERSION_NAME = "idp.previous.installed.version";
    @Nonnull
    private static final Project ANT_PROJECT = new Project();
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(InstallerSupport.class);

    private InstallerSupport() {
    }

    public static void createDirectory(@Nonnull Path dir) throws BuildException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                log.debug("Created directory {}", (Object)dir);
            }
            catch (IOException e) {
                log.error("Could not create {}: {}", (Object)dir, (Object)e.getMessage());
                throw new BuildException((Throwable)e);
            }
        }
    }

    @Nonnull
    public static Copy getCopyTask(@Nonnull Path from, @Nonnull Path to) {
        return InstallerSupport.getCopyTask(from, to, "**/.gitkeep");
    }

    @Nonnull
    public static Copy getCopyTask(@Nonnull Path from, @Nonnull Path to, @Nonnull String excludes) {
        Copy result = new Copy();
        result.setTodir(to.toFile());
        FileSet fromSet = new FileSet();
        fromSet.setDir(from.toFile());
        String[] excludeArray = new String[]{excludes};
        fromSet.appendExcludes(excludeArray);
        result.setPreserveLastModified(true);
        result.addFileset(fromSet);
        result.setProject(ANT_PROJECT);
        result.setVerbose(log.isDebugEnabled());
        return result;
    }

    public static void copyDirIfNotPresent(@Nonnull Path from, @Nonnull Path to) throws BuildException {
        InstallerSupport.createDirectory(to);
        Copy copy = new Copy();
        copy.setTodir(to.toFile());
        FileSet fromSet = new FileSet();
        fromSet.setDir(from.toFile());
        fromSet.setIncludes("**/**");
        PresentSelector present = new PresentSelector();
        present.setPresent((PresentSelector.FilePresence)PresentSelector.FilePresence.getInstance(PresentSelector.FilePresence.class, (String)"srconly"));
        present.setTargetdir(to.toFile());
        fromSet.addPresent(present);
        copy.addFileset(fromSet);
        copy.setProject(ANT_PROJECT);
        copy.setVerbose(log.isDebugEnabled());
        copy.execute();
        log.debug("Copied not-previously-existing files from {} to {}", (Object)from, (Object)to);
    }

    private static void setReadOnlyFile(@Nonnull Path file, boolean readOnly) throws BuildException {
        if (readOnly) {
            log.debug("Setting readonly bits on file {}", (Object)file);
        } else {
            log.debug("Clearing readonly bits on file {}", (Object)file);
        }
        String line = readOnly ? "cmd /c attrib +r \"" + file.toString() + "\"" : "cmd /c attrib -r \"" + file.toString() + "\"";
        String[] command = line.split(" ");
        Execute exec = new Execute();
        exec.setCommandline(command);
        exec.setAntRun(ANT_PROJECT);
        try {
            exec.execute();
        }
        catch (IOException e) {
            log.warn("{} failed: {}", (Object)line, (Object)e.getMessage());
            throw new BuildException((Throwable)e);
        }
    }

    public static void setReadOnlyDir(@Nonnull Path directory, boolean readOnly) throws BuildException {
        if (readOnly) {
            log.debug("Recursively setting readonly bits on directory {}", (Object)directory);
        } else {
            log.debug("Recursively clearing readonly bits on directory {}", (Object)directory);
        }
        String line = readOnly ? "cmd /c attrib /s +r *" : "cmd /c attrib /s -r *";
        String[] command = line.split(" ");
        Execute exec = new Execute();
        exec.setCommandline(command);
        exec.setWorkingDirectory(directory.toFile());
        exec.setAntRun(ANT_PROJECT);
        try {
            exec.execute();
        }
        catch (IOException e) {
            log.warn("{} failed: {}", (Object)line, (Object)e.getMessage());
            throw new BuildException((Throwable)e);
        }
    }

    public static void setReadOnly(@Nonnull Path path, boolean readOnly) throws BuildException {
        if (!Os.isFamily((String)"windows")) {
            log.debug("Not windows. Not [re]setting readonly bit");
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            log.debug("Directory {} does not exist, not performing Attrib -/+r", (Object)path);
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            InstallerSupport.setReadOnlyDir(path, readOnly);
        } else {
            InstallerSupport.setReadOnlyFile(path, readOnly);
        }
    }

    public static void setMode(@Nonnull Path directory, @Nonnull String permissions, @Nonnull String includes) throws BuildException {
        if (!Files.exists(directory, new LinkOption[0])) {
            log.debug("Directory {} does not exist, not performing chmod", (Object)directory);
            return;
        }
        log.debug("Performing chmod {} on {} including {}", new Object[]{permissions, directory, includes});
        if (Os.isFamily((String)"windows")) {
            log.debug("Windows. Not performing chmod");
            return;
        }
        Chmod chmod = new Chmod();
        chmod.setProject(ANT_PROJECT);
        chmod.setPerm(permissions);
        chmod.setDir(directory.toFile());
        chmod.setIncludes(includes);
        chmod.setVerbose(log.isDebugEnabled());
        chmod.execute();
    }

    public static void setGroup(@Nonnull Path directory, @Nonnull String group, @Nonnull String includes) throws BuildException {
        if (!Files.exists(directory, new LinkOption[0])) {
            log.debug("Directory {} does not exist, not performing chgrp", (Object)directory);
            return;
        }
        log.debug("Performing chgrp {} on {} including {}", new Object[]{group, directory, includes});
        if (Os.isFamily((String)"windows")) {
            log.debug("Windows. Not performing chown");
            return;
        }
        Chgrp chgrp = new Chgrp();
        chgrp.setProject(ANT_PROJECT);
        chgrp.setVerbose(log.isDebugEnabled());
        chgrp.setGroup(group);
        FileSet fileSet = new FileSet();
        fileSet.setDir(directory.toFile());
        fileSet.setIncludes(includes);
        chgrp.addFileset(fileSet);
        chgrp.execute();
    }

    public static void deleteTree(@Nullable Path where) throws BuildException {
        InstallerSupport.deleteTree(where, null);
    }

    public static void deleteTree(@Nullable Path where, @Nullable String excludes) throws BuildException {
        if (where == null) {
            return;
        }
        if (where == null || !Files.exists(where, new LinkOption[0])) {
            log.debug("Directory {} does not exist. Skipping delete.", (Object)where);
            return;
        }
        if (!Files.isDirectory(where, new LinkOption[0])) {
            log.error("Directory to be deleted ({}) was a file");
            throw new BuildException("Wanted a directory, found a file");
        }
        log.debug("Deleting tree {}", (Object)where);
        Delete delete = new Delete();
        delete.setProject(ANT_PROJECT);
        delete.setFailOnError(false);
        delete.setIncludeEmptyDirs(true);
        if (excludes != null) {
            FileSet set = new FileSet();
            set.setExcludes(excludes);
            set.setIncludes("**/**");
            set.setDir(where.toFile());
            delete.addFileset(set);
        } else {
            delete.setDir(where.toFile());
        }
        delete.setVerbose(!log.isDebugEnabled());
        delete.execute();
    }

    public static Jar createJarTask(Path baseDir, Path destFile) {
        Jar jarTask = new Jar();
        jarTask.setBasedir(baseDir.toFile());
        jarTask.setDestFile(destFile.toFile());
        jarTask.setProject(ANT_PROJECT);
        return jarTask;
    }

    public static void download(@Nonnull HTTPResource baseResource, @Nonnull HttpClientSecurityContextHandler handler, @Nonnull Path downloadDirectory, @Nonnull String fileName) throws IOException {
        HTTPResource httpResource = baseResource.createRelative(fileName, (HttpClientContextHandler)handler);
        Path filePath = downloadDirectory.resolve(fileName);
        log.info("Downloading from {}", (Object)httpResource.getDescription());
        log.debug("Downloading to {}", (Object)filePath);
        try (ProgressReportingOutputStream fileOut = new ProgressReportingOutputStream(new FileOutputStream(filePath.toFile()));){
            httpResource.getInputStream().transferTo(fileOut);
        }
    }

    @Nonnull
    public static Path canonicalPath(@Nonnull Path from) throws IOException {
        return from.toFile().getCanonicalFile().toPath();
    }

    public static void renameToTree(@Nonnull Path fromBase, @Nonnull Path toBase, @Nonnull List<Path> fromFiles, @Nonnull @Live List<Pair<Path, Path>> renames) throws IOException {
        if (!Files.exists(toBase, new LinkOption[0])) {
            Files.createDirectories(toBase, new FileAttribute[0]);
        }
        for (Path path : fromFiles) {
            if (!Files.exists(path, new LinkOption[0])) {
                log.info("File {} was not renamed away because it does not exist", (Object)path);
                continue;
            }
            Path relName = fromBase.relativize(path);
            log.trace("Relative name {}", (Object)relName);
            Path to = toBase.resolve(relName);
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Files.move(path, to, new CopyOption[0]);
            renames.add((Pair<Path, Path>)new Pair((Object)path, (Object)to));
        }
    }

    public static boolean detectDuplicates(@Nonnull Path from, @Nullable Path to) throws BuildException {
        if (to == null || !Files.exists(to, new LinkOption[0])) {
            return false;
        }
        NameClashVisitor detector = new NameClashVisitor(from, to);
        log.debug("Walking {}, looking for a name clash in {}", (Object)from, (Object)to);
        try {
            Files.walkFileTree(from, detector);
        }
        catch (IOException e) {
            log.error("Failed during duplicate detection:", (Throwable)e);
            throw new BuildException((Throwable)e);
        }
        return detector.wasNameClash();
    }

    public static void copyWithLogging(@Nullable Path from, @Nonnull Path to, @Nonnull @Live List<Path> pathsCopied) throws BuildException {
        if (from == null || !Files.exists(from, new LinkOption[0])) {
            return;
        }
        log.debug("Copying from {} to {}", (Object)from, (Object)to);
        LoggingVisitor visitor = new LoggingVisitor(from, to);
        try {
            Files.walkFileTree(from, visitor);
        }
        catch (IOException e) {
            pathsCopied.addAll(visitor.getCopiedList());
            log.error("Error copying files from {} to {}", new Object[]{from, to, e});
            throw new BuildException((Throwable)e);
        }
        pathsCopied.addAll(visitor.getCopiedList());
    }

    @Nonnull
    public static final Path pathOf(@Nonnull String pathString) throws BuildException {
        try {
            Path result = Path.of(pathString, new String[0]);
            assert (result != null);
            return result;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static final class NameClashVisitor
    extends SimpleFileVisitor<Path> {
        private boolean nameClash;
        private final Path from;
        private final Path to;

        public NameClashVisitor(@Nonnull Path fromDir, @Nonnull Path toDir) {
            this.from = fromDir;
            this.to = toDir;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relFile = this.from.relativize(file);
            Path toFile = this.to.resolve(relFile);
            if (Files.exists(toFile, new LinkOption[0])) {
                this.nameClash = true;
                log.warn("{} already exists", (Object)toFile);
            }
            return FileVisitResult.CONTINUE;
        }

        public boolean wasNameClash() {
            return this.nameClash;
        }
    }

    public static class InstallerQuery
    implements Predicate<String> {
        @Nonnull
        private final String promptText;

        public InstallerQuery(@Nonnull String text) {
            this.promptText = (String)Constraint.isNotNull((Object)text, (String)"Text should not be null");
        }

        @Override
        public boolean test(String keyString) {
            if (System.console() == null) {
                log.error("No Console Attached to installer");
                return false;
            }
            System.console().printf("%s:\n%s [yN] ", this.promptText, keyString);
            System.console().flush();
            String result = StringSupport.trimOrNull((String)System.console().readLine());
            return result != null && "y".equalsIgnoreCase(result.substring(0, 1));
        }
    }
}

