/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.FactoryBean;

public class PKCS11PrivateKeyFactoryBean
implements FactoryBean<PrivateKey> {
    @Nonnull
    @NotEmpty
    private static final String UNCONFIGURED_PROVIDER_NAME = "SunPKCS11";
    @Nullable
    private static Provider provider;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PKCS11PrivateKeyFactoryBean.class);
    @Nullable
    private String pkcs11Config;
    @Nullable
    private String keyAlias;
    @Nullable
    private String keyPassword;
    @Nullable
    private PrivateKey key;

    @Nullable
    public String getPkcs11Config() {
        return this.pkcs11Config;
    }

    public void setPkcs11Config(@Nullable String config) {
        this.pkcs11Config = config;
    }

    @Nullable
    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(@Nullable String alias) {
        this.keyAlias = alias;
    }

    @Nullable
    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(@Nullable String password) {
        this.keyPassword = password;
    }

    @Nonnull
    private Provider getProvider() throws Exception {
        if (provider == null) {
            Provider baseProvider = Security.getProvider(UNCONFIGURED_PROVIDER_NAME);
            if (baseProvider == null) {
                throw new NoSuchProviderException("could not acquire PKCS#11 bridge: SunPKCS11");
            }
            provider = baseProvider.configure(this.pkcs11Config);
            Security.addProvider(provider);
        }
        assert (provider != null);
        return provider;
    }

    @Nonnull
    private KeyStore getKeyStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance("PKCS11", this.getProvider());
        this.log.debug("Initializing PKCS11 keystore");
        keystore.load(null, this.keyPassword != null ? this.keyPassword.toCharArray() : null);
        return keystore;
    }

    @Nonnull
    public PrivateKey getObject() throws Exception {
        if (this.key == null) {
            if (this.keyPassword == null) {
                throw new GeneralSecurityException("Key password was null");
            }
            KeyStore keystore = this.getKeyStore();
            assert (this.keyPassword != null);
            KeyStore.Entry keyEntry = keystore.getEntry(this.keyAlias, new KeyStore.PasswordProtection(this.keyPassword.toCharArray()));
            if (keyEntry == null) {
                throw new GeneralSecurityException("entry " + this.keyAlias + " not found");
            }
            if (keyEntry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
                this.key = privKeyEntry.getPrivateKey();
            } else {
                throw new GeneralSecurityException("entry " + this.keyAlias + " is not a private key entry");
            }
        }
        assert (this.key != null);
        return this.key;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return PrivateKey.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

