/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.criterion;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class SPSessionCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private final String id;
    @Nonnull
    @NotEmpty
    private final String key;

    public SPSessionCriterion(@Nonnull @NotEmpty String serviceId, @Nonnull @NotEmpty String spSessionKey) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)serviceId), (String)"Service ID cannot be null or empty");
        this.key = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)spSessionKey), (String)"SPSession key cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getServiceId() {
        return this.id;
    }

    @Nonnull
    @NotEmpty
    public String getSPSessionKey() {
        return this.key;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceId", (Object)this.id).add("SPSessionKey", (Object)this.key).toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SPSessionCriterion) {
            return this.id.equals(((SPSessionCriterion)obj).id) && this.key.equals(((SPSessionCriterion)obj).key);
        }
        return false;
    }
}

