/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.StartsWithLocationCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.slf4j.Logger;

public class MetadataServiceRegistry
implements ServiceRegistry {
    @Nonnull
    public static final String LOGIN_BINDING = "https://www.apereo.org/cas/protocol/login";
    @Nonnull
    public static final String LOGOUT_BINDING = "https://www.apereo.org/cas/protocol/logout";
    @Nonnull
    public static final String LOGOUT_LOCATION = "urn:mace:shibboleth:profile:CAS:logout";
    @Nonnull
    public static final String PROXY_BINDING = "https://www.apereo.org/cas/protocol/proxy";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataServiceRegistry.class);
    @Nonnull
    private final RoleDescriptorResolver metadataResolver;

    public MetadataServiceRegistry(@Nonnull @ParameterName(name="resolver") RoleDescriptorResolver resolver) {
        this.metadataResolver = resolver;
    }

    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        try {
            RoleDescriptor role = (RoleDescriptor)this.metadataResolver.resolveSingle((Object)this.criteria(serviceURL));
            if (role instanceof SPSSODescriptor) {
                return this.create(serviceURL, (SPSSODescriptor)role);
            }
            throw new ResolverException("No compatible role resolved");
        }
        catch (ResolverException e) {
            this.log.warn("Metadata resolution failed for {}", (Object)serviceURL, (Object)e);
            return null;
        }
    }

    @Nonnull
    protected CriteriaSet criteria(@Nonnull String serviceURL) {
        AssertionConsumerService loginACS = new AssertionConsumerServiceBuilder().buildObject();
        loginACS.setBinding(LOGIN_BINDING);
        loginACS.setLocation(serviceURL);
        return new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new EndpointCriterion((Endpoint)loginACS), new ProtocolCriterion("https://www.apereo.org/cas/protocol"), new StartsWithLocationCriterion()});
    }

    @Nonnull
    protected Service create(@Nonnull String serviceURL, @Nonnull SPSSODescriptor role) {
        EntityDescriptor entity = (EntityDescriptor)role.getParent();
        assert (entity != null);
        XMLObject parent = entity.getParent();
        Service service = new Service(serviceURL, parent instanceof EntitiesDescriptor ? ((EntitiesDescriptor)parent).getName() : "unknown", this.isAuthorizedToProxy(role), this.hasSingleLogoutService(role));
        service.setRoleDescriptor((RoleDescriptor)role);
        service.setEntityDescriptor(entity);
        return service;
    }

    private boolean isAuthorizedToProxy(@Nonnull SPSSODescriptor role) {
        for (AssertionConsumerService acs : role.getAssertionConsumerServices()) {
            if (!PROXY_BINDING.equals(acs.getBinding())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSingleLogoutService(@Nonnull SPSSODescriptor role) {
        for (Endpoint endpoint : role.getEndpoints(SingleLogoutService.DEFAULT_ELEMENT_NAME)) {
            if (!LOGOUT_BINDING.equals(endpoint.getBinding()) || !LOGOUT_LOCATION.equals(endpoint.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static class LoginEndpointPredicate
    implements Predicate<Endpoint> {
        @Override
        public boolean test(@Nullable Endpoint endpoint) {
            assert (endpoint != null);
            return MetadataServiceRegistry.LOGIN_BINDING.equals(endpoint.getBinding());
        }
    }
}

