/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractAttributeTranscoder<T>
extends AbstractInitializableComponent
implements AttributeTranscoder<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeTranscoder.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    @Nullable
    private Function<ProfileRequestContext, Set<String>> nameFromMetadataLookupStrategy;

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    public void setNameFromMetadataLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.checkSetterPreconditions();
        this.nameFromMetadataLookupStrategy = strategy;
    }

    @Override
    @Nullable
    public T encode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends T> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)attribute, (String)"Attribute to encode cannot be null");
        if (!this.checkActivation(profileRequestContext, rule)) {
            return null;
        }
        return this.doEncode(profileRequestContext, attribute, to, rule);
    }

    @Override
    @Nullable
    public IdPAttribute decode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull T input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        this.checkComponentActive();
        Constraint.isNotNull(input, (String)"Attribute to decode cannot be null");
        if (!this.checkActivation(profileRequestContext, rule)) {
            return null;
        }
        IdPAttribute attribute = this.doDecode(profileRequestContext, input, rule);
        return attribute;
    }

    @Nullable
    protected String getNameFromMetadata(@Nullable ProfileRequestContext profileRequestContext, @Nonnull String attributeId) {
        if (this.nameFromMetadataLookupStrategy != null) {
            Set<String> tagValues = this.nameFromMetadataLookupStrategy.apply(profileRequestContext);
            if (tagValues != null) {
                for (String tagValue : tagValues) {
                    String ret;
                    if (tagValue == null || !tagValue.startsWith(attributeId + " ") || (ret = tagValue.substring(attributeId.length() + 1)).isEmpty()) continue;
                    return ret;
                }
                this.log.debug("No applicable tag value found for metadata-driven naming for {}", (Object)attributeId);
            } else {
                this.log.debug("No tag values found for metadata-driven naming for {}", (Object)attributeId);
            }
        }
        return null;
    }

    @Nullable
    protected abstract T doEncode(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull Class<? extends T> var3, @Nonnull TranscodingRule var4) throws AttributeEncodingException;

    @Nullable
    protected abstract IdPAttribute doDecode(@Nullable ProfileRequestContext var1, @Nonnull T var2, @Nonnull TranscodingRule var3) throws AttributeDecodingException;

    private boolean checkActivation(@Nullable ProfileRequestContext profileRequestContext, @Nonnull TranscodingRule rule) {
        if (!this.activationCondition.test(profileRequestContext)) {
            this.log.debug("Transcoder type {} inactive", (Object)this.getClass().getName());
            return false;
        }
        Predicate condition = rule.get("activationCondition", Predicate.class);
        if (condition != null && !condition.test(profileRequestContext)) {
            this.log.debug("Transcoder rule for {} inactive", (Object)rule.get("id", String.class));
            return false;
        }
        return true;
    }
}

