/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;

public class StringConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<String> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(StringConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected String doTranslate(@Nonnull IdPAttribute tag) {
        List<IdPAttributeValue> values = tag.getValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        LOG.debug("Converting tag '{}' to String property", (Object)tag.getId());
        IdPAttributeValue value = values.get(0);
        if (value instanceof StringAttributeValue) {
            StringAttributeValue strval = (StringAttributeValue)value;
            return strval.getValue();
        }
        LOG.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected String doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        LOG.debug("Converting tag '{}' to String property", (Object)tag.getName());
        XMLObject value = (XMLObject)values.get(0);
        assert (value != null);
        return this.xmlObjectToString(value);
    }

    @Nullable
    private String xmlObjectToString(@Nonnull XMLObject object) {
        XSAny val;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            return val2.getValue();
        }
        if (object instanceof XSURI) {
            XSURI val3 = (XSURI)object;
            return val3.getURI();
        }
        if (object instanceof XSBoolean) {
            XSBoolean val4 = (XSBoolean)object;
            XSBooleanValue value = val4.getValue();
            return value != null ? (value.getValue().booleanValue() ? "1" : "0") : null;
        }
        if (object instanceof XSInteger) {
            XSInteger val5 = (XSInteger)object;
            Integer value = val5.getValue();
            return value != null ? value.toString() : null;
        }
        if (object instanceof XSDateTime) {
            XSDateTime val6 = (XSDateTime)object;
            Instant dt = val6.getValue();
            return dt != null ? Long.toString(dt.toEpochMilli()) : null;
        }
        if (object instanceof XSBase64Binary) {
            XSBase64Binary val7 = (XSBase64Binary)object;
            return val7.getValue();
        }
        if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            return val.getTextContent();
        }
        LOG.error("Unsupported conversion to String from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

