/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;

public class LongConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Long> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(LongConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Long doTranslate(@Nonnull IdPAttribute tag) {
        List<IdPAttributeValue> values = tag.getValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        LOG.debug("Converting tag '{}' to Long property", (Object)tag.getId());
        IdPAttributeValue value = values.get(0);
        if (value instanceof StringAttributeValue) {
            StringAttributeValue strval = (StringAttributeValue)value;
            return Long.decode(strval.getValue());
        }
        LOG.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Long doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        LOG.debug("Converting tag '{}' to Long property", (Object)tag.getName());
        XMLObject value = (XMLObject)values.get(0);
        assert (value != null);
        return this.xmlObjectToLong(value);
    }

    @Nullable
    private Long xmlObjectToLong(@Nonnull XMLObject object) {
        XSAny val;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            String value = val2.getValue();
            return value != null ? Long.decode(value) : null;
        }
        if (object instanceof XSBoolean) {
            XSBoolean val3 = (XSBoolean)object;
            XSBooleanValue value = val3.getValue();
            return value != null ? Long.valueOf(value.getValue() != false ? 1L : 0L) : null;
        }
        if (object instanceof XSInteger) {
            XSInteger val4 = (XSInteger)object;
            Integer value = val4.getValue();
            return value != null ? Long.valueOf(value.longValue()) : null;
        }
        if (object instanceof XSDateTime) {
            XSDateTime val5 = (XSDateTime)object;
            Instant dt = val5.getValue();
            return dt != null ? Long.valueOf(dt.toEpochMilli()) : null;
        }
        if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            String value = val.getTextContent();
            return value != null ? Long.decode(value) : null;
        }
        LOG.error("Unsupported conversion to Long from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

