/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LockableClassToInstanceMultiMap;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ProfileIdLookup;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.soap.client.security.SOAPClientSecurityProfileIdLookupFunction;
import org.slf4j.Logger;

public abstract class AbstractMetadataDrivenConfigurationLookupStrategy<T>
extends AbstractInitializableComponent
implements Function<BaseContext, T> {
    @Nonnull
    private static final Function<ProfileRequestContext, String> DEFAULT_PRC_PROFILE_ID_LOOKUP;
    @Nonnull
    private static final Function<MessageContext, String> DEFAULT_MC_PROFILE_ID_LOOKUP;
    @Nonnull
    private static final Logger LOG;
    private boolean strictNameFormat;
    private boolean enableCaching = true;
    private boolean ignoreUnmappedEntityAttributes;
    private boolean explicitPropertyName;
    @NonnullAfterInit
    @NotEmpty
    private String propertyName;
    @Nullable
    @NotEmpty
    private String legacyPropertyName;
    @NonnullAfterInit
    private Collection<String> propertyAliases;
    @Nullable
    private Collection<String> legacyPropertyAliases;
    @Nonnull
    private Function<BaseContext, T> defaultValueStrategy = FunctionSupport.constant(null);
    @Nullable
    private Function<ProfileRequestContext, EntityDescriptor> profileMetadataLookupStrategy;
    @Nullable
    private Function<MessageContext, EntityDescriptor> messageMetadataLookupStrategy;
    @Nullable
    private Function<BaseContext, String> profileIdLookupStrategy;

    public void setStrictNameFormat(boolean flag) {
        this.checkSetterPreconditions();
        this.strictNameFormat = flag;
    }

    public void setEnableCaching(boolean flag) {
        this.checkSetterPreconditions();
        this.enableCaching = flag;
    }

    public void setIgnoreUnmappedEntityAttributes(boolean flag) {
        this.checkSetterPreconditions();
        this.ignoreUnmappedEntityAttributes = flag;
    }

    public void setExplicitPropertyName(boolean flag) {
        this.checkSetterPreconditions();
        this.explicitPropertyName = flag;
    }

    @Nonnull
    private String ensurePropertyName() {
        this.checkComponentActive();
        return this.propertyName;
    }

    public void setPropertyName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.propertyName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Property name cannot be null or empty");
    }

    public void setLegacyPropertyName(@Nullable @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.legacyPropertyName = StringSupport.trimOrNull((String)name);
    }

    public void setProfileAliases(@Nonnull Collection<String> aliases) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(aliases, (String)"Alias collection cannot be null");
        this.propertyAliases = List.copyOf(StringSupport.normalizeStringCollection(aliases));
    }

    public void setDefaultValue(@Nullable T value) {
        this.checkSetterPreconditions();
        this.defaultValueStrategy = FunctionSupport.constant(value);
    }

    public void setDefaultValueStrategy(@Nonnull Function<BaseContext, T> strategy) {
        this.checkSetterPreconditions();
        this.defaultValueStrategy = (Function)Constraint.isNotNull(strategy, (String)"Default value strategy cannot be null");
    }

    public void setProfileMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityDescriptor> strategy) {
        this.checkSetterPreconditions();
        this.profileMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata lookup strategy cannot be null");
    }

    public void setMessageMetadataLookupStrategy(@Nonnull Function<MessageContext, EntityDescriptor> strategy) {
        this.checkSetterPreconditions();
        this.messageMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata lookup strategy cannot be null");
    }

    public void setProfileIdLookupStrategy(@Nonnull Function<BaseContext, String> strategy) {
        this.checkSetterPreconditions();
        this.profileIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyName == null) {
            throw new ComponentInitializationException("Property name cannot be null or empty");
        }
        if (this.propertyAliases == null) {
            this.propertyAliases = CollectionSupport.emptyList();
        }
        if (this.legacyPropertyName != null) {
            List<String> aliases = List.copyOf(this.propertyAliases);
            this.legacyPropertyAliases = (Collection)((NonnullSupplier)aliases.stream().map(s -> s + (String)(s.endsWith("/") ? this.legacyPropertyName : "/" + this.legacyPropertyName)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        }
        this.propertyAliases = (Collection)((NonnullSupplier)this.propertyAliases.stream().map(s -> s + (String)(s.endsWith("/") ? this.propertyName : "/" + this.propertyName)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    @Override
    @Nullable
    public T apply(@Nullable BaseContext input) {
        EntityDescriptor entity;
        this.checkComponentActive();
        CachedConfigurationContext cacheContext = null;
        if (this.enableCaching && input != null && (cacheContext = (CachedConfigurationContext)input.ensureSubcontext(CachedConfigurationContext.class)).getPropertyMap().containsKey(this.propertyName)) {
            LOG.debug("Returning cached property '{}'", (Object)this.propertyName);
            return (T)cacheContext.getPropertyMap().get(this.ensurePropertyName());
        }
        if (input instanceof ProfileRequestContext) {
            ProfileRequestContext prc = (ProfileRequestContext)input;
            if (this.profileMetadataLookupStrategy != null) {
                entity = this.profileMetadataLookupStrategy.apply(prc);
            } else {
                entity = null;
                LOG.warn("No lookup strategy installed for locating metadata from ProfileRequestContext");
            }
        } else if (input instanceof MessageContext) {
            MessageContext mc = (MessageContext)input;
            if (this.messageMetadataLookupStrategy != null) {
                entity = this.messageMetadataLookupStrategy.apply(mc);
            } else {
                entity = null;
                LOG.warn("No lookup strategy installed for locating metadata from MessageContext");
            }
        } else {
            entity = null;
        }
        if (entity == null) {
            LOG.debug("No metadata available for relying party, applying default strategy for '{}'", (Object)this.propertyName);
            return this.defaultValueStrategy.apply(input);
        }
        String profileId = !this.explicitPropertyName ? (this.profileIdLookupStrategy != null ? this.profileIdLookupStrategy.apply(input) : (input instanceof ProfileRequestContext ? DEFAULT_PRC_PROFILE_ID_LOOKUP.apply((ProfileRequestContext)input) : (input instanceof MessageContext ? DEFAULT_MC_PROFILE_ID_LOOKUP.apply((MessageContext)input) : ""))) : null;
        IdPAttribute idpAttribute = this.findMatchingMappedTag(entity, (String)(profileId != null ? profileId + "/" + this.ensurePropertyName() : this.ensurePropertyName()));
        Optional<Object> result = this.processMappedTag(idpAttribute, cacheContext);
        if (result != null) {
            assert (idpAttribute != null);
            LOG.debug("Found matching mapped tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
            return result.orElse(null);
        }
        for (String string : this.propertyAliases) {
            assert (string != null);
            idpAttribute = this.findMatchingMappedTag(entity, string);
            result = this.processMappedTag(idpAttribute, cacheContext);
            if (result == null) continue;
            assert (idpAttribute != null);
            LOG.debug("Found matching mapped tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
            return result.orElse(null);
        }
        if (this.legacyPropertyName != null) {
            String legacy = this.legacyPropertyName;
            idpAttribute = this.findMatchingMappedTag(entity, (String)(profileId != null ? profileId + "/" + legacy : legacy));
            result = this.processMappedTag(idpAttribute, cacheContext);
            if (result != null) {
                assert (idpAttribute != null);
                LOG.debug("Found matching mapped tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)legacy, (String)"SAML Metadata EntityAttribute", (String)this.propertyName);
                return result.orElse(null);
            }
            if (this.legacyPropertyAliases != null) {
                for (String alias : this.legacyPropertyAliases) {
                    assert (alias != null);
                    idpAttribute = this.findMatchingMappedTag(entity, alias);
                    result = this.processMappedTag(idpAttribute, cacheContext);
                    if (result == null) continue;
                    assert (idpAttribute != null);
                    LOG.debug("Found matching mapped tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
                    DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)legacy, (String)"SAML Metadata EntityAttribute", (String)this.propertyName);
                    return result.orElse(null);
                }
            }
        }
        if (this.ignoreUnmappedEntityAttributes) {
            LOG.debug("No applicable mapped tag, applying default strategy for '{}'", (Object)this.propertyName);
            T ret = this.defaultValueStrategy.apply(input);
            if (this.enableCaching) {
                assert (cacheContext != null);
                cacheContext.getPropertyMap().put(this.propertyName, ret);
            }
            return ret;
        }
        Attribute attribute = this.findMatchingTag(entity, (String)(profileId != null ? profileId + "/" + this.ensurePropertyName() : this.ensurePropertyName()));
        result = this.processTag(attribute, cacheContext);
        if (result != null) {
            assert (attribute != null);
            LOG.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            return result.orElse(null);
        }
        for (String alias : this.propertyAliases) {
            assert (alias != null);
            attribute = this.findMatchingTag(entity, alias);
            result = this.processTag(attribute, cacheContext);
            if (result == null) continue;
            assert (attribute != null);
            LOG.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            return result.orElse(null);
        }
        if (this.legacyPropertyName != null) {
            String string = this.legacyPropertyName;
            attribute = this.findMatchingTag(entity, (String)(profileId != null ? profileId + "/" + string : string));
            result = this.processTag(attribute, cacheContext);
            if (result != null) {
                assert (attribute != null);
                LOG.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
                DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)string, (String)"SAML Metadata EntityAttribute", (String)this.propertyName);
                return result.orElse(null);
            }
            if (this.legacyPropertyAliases != null) {
                for (String alias : this.legacyPropertyAliases) {
                    assert (alias != null);
                    attribute = this.findMatchingTag(entity, alias);
                    result = this.processMappedTag(idpAttribute, cacheContext);
                    if (result == null) continue;
                    assert (attribute != null);
                    LOG.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
                    DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.PROPERTY, (String)string, (String)"SAML Metadata EntityAttribute", (String)this.propertyName);
                    return result.orElse(null);
                }
            }
        }
        LOG.debug("No applicable tag, applying default strategy for '{}'", (Object)this.propertyName);
        T t = this.defaultValueStrategy.apply(input);
        if (this.enableCaching) {
            assert (cacheContext != null);
            cacheContext.getPropertyMap().put(this.propertyName, t);
        }
        return t;
    }

    @Nullable
    private T translate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values == null || values.isEmpty()) {
            LOG.debug("Tag '{}' contained no values, no setting returned for '{}'", (Object)tag.getName(), (Object)this.propertyName);
            return null;
        }
        return this.doTranslate(tag);
    }

    @Nullable
    private T translate(@Nonnull IdPAttribute tag) {
        return this.doTranslate(tag);
    }

    @Nullable
    protected abstract T doTranslate(@Nonnull Attribute var1);

    @Nullable
    protected abstract T doTranslate(@Nonnull IdPAttribute var1);

    @Nullable
    private Optional<T> processMappedTag(@Nullable IdPAttribute tag, @Nullable CachedConfigurationContext cacheContext) {
        if (tag != null && !tag.getValues().isEmpty()) {
            T result = this.translate(tag);
            if (cacheContext != null) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return Optional.ofNullable(result);
        }
        return null;
    }

    @Nullable
    private Optional<T> processTag(@Nullable Attribute tag, @Nullable CachedConfigurationContext cacheContext) {
        if (tag != null) {
            T result = this.translate(tag);
            if (cacheContext != null) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return Optional.ofNullable(result);
        }
        return null;
    }

    @Nullable
    private IdPAttribute findMatchingMappedTag(@Nonnull EntityDescriptor entity, @Nonnull @NotEmpty String name) {
        IdPAttribute tag = this.findMatchingMappedTag(entity.getObjectMetadata(), name);
        if (tag != null) {
            return tag;
        }
        XMLObject parent = entity.getParent();
        while (parent instanceof EntitiesDescriptor) {
            tag = this.findMatchingMappedTag(parent.getObjectMetadata(), name);
            if (tag != null) {
                return tag;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityDescriptor entity, @Nonnull @NotEmpty String name) {
        EntityAttributes attr;
        Attribute tag;
        Object e;
        List children;
        Extensions exts = entity.getExtensions();
        if (exts != null && !(children = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() && (e = children.get(0)) instanceof EntityAttributes && (tag = this.findMatchingTag(attr = (EntityAttributes)e, name)) != null) {
            return tag;
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)entity.getParent(); group != null; group = (EntitiesDescriptor)group.getParent()) {
            EntityAttributes attr2;
            Attribute tag2;
            Object e2;
            List children2;
            exts = group.getExtensions();
            if (exts == null || (children2 = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() || !((e2 = children2.get(0)) instanceof EntityAttributes) || (tag2 = this.findMatchingTag(attr2 = (EntityAttributes)e2, name)) == null) continue;
            return tag2;
        }
        return null;
    }

    @Nullable
    private IdPAttribute findMatchingMappedTag(@Nonnull LockableClassToInstanceMultiMap<?> input, @Nonnull @NotEmpty String name) {
        List containerList = input.get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty()) {
            return null;
        }
        AttributesMapContainer container = (AttributesMapContainer)containerList.get(0);
        if (container == null || container.get().isEmpty()) {
            return null;
        }
        Collection matches = container.get().get((Object)name);
        return matches.isEmpty() ? null : (IdPAttribute)matches.iterator().next();
    }

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityAttributes entityAttributes, @Nonnull @NotEmpty String name) {
        for (Attribute tag : entityAttributes.getAttributes()) {
            if (!Objects.equals(tag.getName(), name) || this.strictNameFormat && !Objects.equals(tag.getNameFormat(), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri")) continue;
            return tag;
        }
        return null;
    }

    static {
        LOG = LoggerFactory.getLogger(AbstractMetadataDrivenConfigurationLookupStrategy.class);
        DEFAULT_PRC_PROFILE_ID_LOOKUP = new ProfileIdLookup();
        DEFAULT_MC_PROFILE_ID_LOOKUP = new SOAPClientSecurityProfileIdLookupFunction();
    }

    public static final class CachedConfigurationContext
    extends BaseContext {
        @Nonnull
        private Map<String, Object> propertyMap = new HashMap<String, Object>();

        @Nonnull
        @Live
        Map<String, Object> getPropertyMap() {
            return this.propertyMap;
        }
    }
}

