/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameIDType;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public final class XMLObjectAttributeValue
implements IdPAttributeValue {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(XMLObjectAttributeValue.class);
    @Nonnull
    private final XMLObject value;

    public XMLObjectAttributeValue(@Nonnull @ParameterName(name="attributeValue") XMLObject attributeValue) {
        this.value = (XMLObject)Constraint.isNotNull((Object)attributeValue, (String)"Attribute value cannot be null");
    }

    @Override
    @Nonnull
    public Object getNativeValue() {
        return this.value;
    }

    @Nonnull
    public final XMLObject getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getDisplayValue() {
        String n;
        if (this.value instanceof NameIDType && (n = ((NameIDType)this.value).getValue()) != null) {
            return n;
        }
        try {
            return SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)this.value));
        }
        catch (MarshallingException e) {
            LOG.error("Error while marshalling XMLObject value", (Throwable)e);
            return "(unable to get value)";
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XMLObjectAttributeValue)) {
            return false;
        }
        XMLObjectAttributeValue other = (XMLObjectAttributeValue)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

