/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@NotThreadSafe
public class IdPAttribute
implements Comparable<IdPAttribute>,
Cloneable {
    @Nonnull
    private static final Predicate<String> SPACE_CONTAINING = Pattern.compile("\\S*").asMatchPredicate();
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(IdPAttribute.class);
    @Nonnull
    private final String id;
    @Nonnull
    private List<IdPAttributeValue> values;

    public IdPAttribute(@Nonnull @ParameterName(name="attributeId") @NotEmpty String attributeId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID may not be null");
        Constraint.isFalse((boolean)IdPAttribute.isInvalidId(this.id), (String)"Attribute ID must not have spaces");
        if (IdPAttribute.isDeprecatedId(this.id)) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"IdPAttribute", (String)"IdPAttribute id with special characters ('\"%{})", null);
            LOG.debug("{} - deprecated character in attribute name", (Object)this.id);
            LOG.trace("Stack", (Throwable)new Exception("Stack Trace, not a thrown exception:"));
        }
        this.values = CollectionSupport.emptyList();
    }

    public static boolean isDeprecatedId(@Nonnull @NotEmpty String id) {
        return id.indexOf(39) >= 0 || id.indexOf(37) >= 0 || id.indexOf(123) >= 0 || id.indexOf(125) >= 0;
    }

    public static boolean isInvalidId(@Nullable String id) {
        return null == StringSupport.trimOrNull((String)id) || !SPACE_CONTAINING.test(id);
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<IdPAttributeValue> getValues() {
        return this.values;
    }

    public void setValues(@Nullable @NullableElements List<IdPAttributeValue> newValues) {
        this.values = newValues != null ? (List)((NonnullSupplier)newValues.stream().map(e -> e == null ? new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE) : e).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get() : CollectionSupport.emptyList();
    }

    public boolean contains(@Nonnull @NotEmpty String value) {
        for (IdPAttributeValue v : this.values) {
            if (!(v instanceof StringAttributeValue) || !((StringAttributeValue)v).getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IdPAttribute other) {
        return this.getId().compareTo(other.getId());
    }

    @Nonnull
    public IdPAttribute clone() throws CloneNotSupportedException {
        IdPAttribute clone = (IdPAttribute)super.clone();
        clone.setValues(this.getValues());
        return clone;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdPAttribute)) {
            return false;
        }
        IdPAttribute other = (IdPAttribute)obj;
        return Objects.equals(this.id, other.getId());
    }

    @Nonnull
    public String toString() {
        String result = MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("values", this.values).toString();
        assert (result != null);
        return result;
    }
}

