/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.httpclient.FileCachingHttpClientBuilder;
import org.apache.hc.client5.http.classic.HttpClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class FileCachingHttpClientFactoryBean
extends FileCachingHttpClientBuilder
implements FactoryBean<HttpClient>,
DisposableBean {
    @Nullable
    private HttpClient singletonInstance;

    public boolean isSingleton() {
        return true;
    }

    @Nonnull
    public Class<HttpClient> getObjectType() {
        return HttpClient.class;
    }

    public void destroy() {
        HttpClient httpClient = this.singletonInstance;
        if (httpClient instanceof DestructableComponent) {
            DestructableComponent c = (DestructableComponent)httpClient;
            c.destroy();
        }
    }

    @Nonnull
    public HttpClient getObject() throws Exception {
        if (this.singletonInstance == null) {
            HttpClient theBean = this.buildClient();
            if (theBean instanceof InitializableComponent) {
                InitializableComponent c = (InitializableComponent)theBean;
                c.initialize();
            }
            this.singletonInstance = theBean;
        }
        assert (this.singletonInstance != null);
        return this.singletonInstance;
    }
}

