/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ReleaseAttributes
extends AbstractAttributeReleaseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReleaseAttributes.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        AttributeContext attributeContext = this.getAttributeContext();
        AttributeReleaseContext releaseContext = this.getAttributeReleaseContext();
        ConsentContext consentContext = this.getConsentContext();
        assert (attributeContext != null && releaseContext != null && consentContext != null);
        Map consents = consentContext.getCurrentConsents().isEmpty() ? consentContext.getPreviousConsents() : consentContext.getCurrentConsents();
        this.log.debug("{} Consents '{}'", (Object)this.getLogPrefix(), (Object)consents);
        Map attributes = attributeContext.getIdPAttributes();
        this.log.debug("{} Attributes before release: {}", (Object)this.getLogPrefix(), attributes.keySet());
        HashMap<String, IdPAttribute> releasedAttributes = new HashMap<String, IdPAttribute>(attributes.size());
        for (IdPAttribute attribute : attributes.values()) {
            if (!releaseContext.getConsentableAttributes().containsKey(attribute.getId())) {
                this.log.debug("{} Attribute '{}' will be released because it is excluded from consent", (Object)this.getLogPrefix(), (Object)attribute.getId());
                releasedAttributes.put(attribute.getId(), attribute);
                continue;
            }
            if (!consents.containsKey(attribute.getId())) {
                this.log.debug("{} Attribute '{}' will not be released because consent for it does not exist", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            Consent consent = (Consent)consents.get(attribute.getId());
            if (consent.isApproved()) {
                this.log.debug("{} Attribute '{}' will be released because consent is approved", (Object)this.getLogPrefix(), (Object)attribute.getId());
                releasedAttributes.put(attribute.getId(), attribute);
                continue;
            }
            this.log.debug("{} Attribute '{}' will not be released because consent is not approved", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Releasing attributes: {}", (Object)this.getLogPrefix(), releasedAttributes.keySet());
            MapDifference diff = Maps.difference((Map)attributes, releasedAttributes);
            this.log.debug("{} Not releasing attributes: {}", (Object)this.getLogPrefix(), diff.entriesOnlyOnLeft().keySet());
        }
        attributeContext.setIdPAttributes(releasedAttributes);
    }
}

