/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class GenericPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_TYPE_FIELD = "typ";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "nam";
    @Nonnull
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"typ\":.*,\"nam\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenericPrincipalSerializer.class);
    @Nonnull
    private BiMap<String, Integer> symbolics;
    @Nonnull
    private final Set<Class<? extends Principal>> compatiblePrincipalTypes;

    public GenericPrincipalSerializer() {
        ImmutableBiMap s = ImmutableBiMap.of();
        assert (s != null);
        this.symbolics = s;
        Set cpt = Collections.synchronizedSet(new HashSet());
        assert (cpt != null);
        this.compatiblePrincipalTypes = cpt;
    }

    public void setSymbolics(@Nonnull Map<String, Integer> mappings) {
        this.checkSetterPreconditions();
        HashBiMap s = HashBiMap.create((Map)((Map)Constraint.isNotNull(mappings, (String)"Mappings cannot be null")));
        assert (s != null);
        this.symbolics = s;
    }

    @Override
    public boolean supports(@Nonnull Principal principal) {
        Class<?> principalType = principal.getClass();
        if (this.compatiblePrincipalTypes.contains(principalType)) {
            return true;
        }
        try {
            principalType.getConstructor(String.class);
            this.compatiblePrincipalTypes.add(principalType);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.log.warn("Unsupported Principal type will be omitted: {}", (Object)principalType.getName());
            return false;
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        this.checkComponentActive();
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject();
            Integer symbol = (Integer)this.symbolics.get((Object)principal.getClass().getName());
            if (symbol != null) {
                gen.write(PRINCIPAL_TYPE_FIELD, symbol.intValue());
            } else {
                gen.write(PRINCIPAL_TYPE_FIELD, principal.getClass().getName());
            }
            symbol = (Integer)this.symbolics.get((Object)principal.getName());
            if (symbol != null) {
                gen.write(PRINCIPAL_NAME_FIELD, symbol.intValue());
            } else {
                gen.write(PRINCIPAL_NAME_FIELD, principal.getName());
            }
            gen.writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    @Override
    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Principal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        this.checkComponentActive();
        try {
            reader = this.getJsonReader(new StringReader(value));
            try {
                block14: {
                    st = reader.read();
                    if (!(st instanceof JsonObject)) {
                        throw new IOException("Found invalid data structure while parsing a generic principal");
                    }
                    obj = (JsonObject)st;
                    typefield = (JsonValue)obj.get((Object)"typ");
                    namefield = (JsonValue)obj.get((Object)"nam");
                    if (typefield == null || namefield == null) break block14;
                    type = this.desymbolize(typefield);
                    name = this.desymbolize(namefield);
                    if (!Strings.isNullOrEmpty((String)type) && !Strings.isNullOrEmpty((String)name)) {
                        try {
                            pclass = Class.forName(type).asSubclass(Principal.class);
                            ctor = pclass.getConstructor(new Class[]{String.class});
                            var11_15 = ctor.newInstance(new Object[]{name});
                            return var11_15;
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            this.log.warn("Exception instantiating custom Principal type {} with name {}", new Object[]{type, name, e});
lbl22:
                            // 3 sources

                            while (true) {
                                var7_10 = null;
                                return var7_10;
                            }
                        }
                    }
                    this.log.warn("Unparseable Principal type or name in structure");
                    ** GOTO lbl22
                }
                this.log.warn("Missing Principal type or name in structure");
                ** continue;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing a generic principal", e);
        }
    }

    @Nullable
    protected String desymbolize(@Nonnull JsonValue field) {
        switch (field.getValueType()) {
            case STRING: {
                return ((JsonString)field).getString();
            }
            case NUMBER: {
                return (String)this.symbolics.inverse().get((Object)((JsonNumber)field).intValueExact());
            }
        }
        return null;
    }
}

