/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class MultiFactorAuthenticationContext
extends BaseContext {
    @Nonnull
    private Map<String, MultiFactorAuthenticationTransition> transitionMap = new HashMap<String, MultiFactorAuthenticationTransition>();
    @Nonnull
    private final Map<String, AuthenticationResult> activeResults = new HashMap<String, AuthenticationResult>();
    @Nullable
    private AuthenticationFlowDescriptor mfaFlowDescriptor;
    @Nullable
    @NotEmpty
    private String nextFlowId;
    @Nullable
    @NotEmpty
    private String nextWebFlowId;
    @Nullable
    @NotEmpty
    private String event;

    @Nonnull
    @Live
    public Map<String, MultiFactorAuthenticationTransition> getTransitionMap() {
        return this.transitionMap;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setTransitionMap(@Nonnull Map<String, MultiFactorAuthenticationTransition> map) {
        Constraint.isNotNull(map, (String)"Map cannot be null");
        this.transitionMap.clear();
        for (Map.Entry<String, MultiFactorAuthenticationTransition> entry : map.entrySet()) {
            String trimmed = StringSupport.trimOrNull((String)entry.getKey());
            if (entry.getValue() == null) continue;
            this.transitionMap.put(trimmed, entry.getValue());
        }
        return this;
    }

    @Nonnull
    @Live
    public Map<String, AuthenticationResult> getActiveResults() {
        return this.activeResults;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAuthenticationFlowDescriptor() {
        return this.mfaFlowDescriptor;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setAuthenticationFlowDescriptor(@Nullable AuthenticationFlowDescriptor descriptor) {
        this.mfaFlowDescriptor = descriptor;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getNextFlowId() {
        return this.nextFlowId;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setNextFlowId(@Nullable @NotEmpty String id) {
        this.nextFlowId = StringSupport.trimOrNull((String)id);
        return this.setNextWebFlowId(this.nextFlowId);
    }

    @Nullable
    @NotEmpty
    public String getNextWebFlowId() {
        return this.nextWebFlowId;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setNextWebFlowId(@Nullable @NotEmpty String id) {
        this.nextWebFlowId = StringSupport.trimOrNull((String)id);
        return this;
    }

    @Nullable
    @NotEmpty
    public String getEvent() {
        return this.event;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setEvent(@Nullable @NotEmpty String e) {
        this.event = StringSupport.trimOrNull((String)e);
        return this;
    }

    public boolean isAcceptable() {
        AuthenticationContext authnContext = (AuthenticationContext)this.getParent();
        if (authnContext != null) {
            for (AuthenticationResult result : this.activeResults.values()) {
                assert (result != null);
                if (authnContext.isForceAuthn() && result.isPreviousResult() || !authnContext.isAcceptable(result)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActive(@Nonnull Principal principal) {
        AuthenticationContext authnContext = (AuthenticationContext)this.getParent();
        if (authnContext != null) {
            for (AuthenticationResult result : this.activeResults.values()) {
                Subject subject;
                assert (result != null);
                if (authnContext.isForceAuthn() && result.isPreviousResult() || !(subject = result.getSubject()).getPrincipals().contains(principal)) continue;
                return true;
            }
        }
        return false;
    }
}

